import com.swath.*;
import com.swath.cmd.*;
import java.util.Random;

//TollFig VERSION 3 ALPHA


// this script will move you there and then attack the victim...
// The victim has about 2 seconds to retreat, or about
// 1 second to destroy the fighter before you can use it as a t-warp beacon
// ------------------------------------------------------------------------
// Parameters:
// fighters     = how many fighters to use when attacking....
//                it is your responsibility to make sure the ship combat computer 
//                is able to attack with the amount you specify (e.g., ISS max is 10000)
// hunttrader   = only hunts a specific trader.  Anyone else who crosses a toll fighter
//                will be ignored. 
// fearic       = Fear the interdictor cruiser? 
// hitandrun    = if a sector is entered here, the script warps you in, gives one hit,
//                and immediately moves you to the run sector. If it is left blank,
//                you will remain in the attack sector and the script will end....
// ignoretrader1,2,3 = Runtime parameter of (max 3) traders to ignore.
//                     Also you can hard-code traders that you always want to ignore.
//                     You can hard-code an unlimited number of traders!
//                     Remember to compile the script after you hard-code their names!!!


public class TollFig extends UserDefinedScript {
        private Parameter m_fighters;
        private Parameter m_ignoretrader1;
        private Parameter m_ignoretrader2;
        private Parameter m_ignoretrader3;
        private Parameter m_hunttrader;
        private Parameter m_fearic;
        private Parameter m_hitandrun;
        private Parameter m_verbose;
        private Parameter m_hrchoice;
        private Parameter m_numberofhits;
        
        public String getName() {
                return "Toll Fig";
        }

        public boolean initScript() throws Exception {
                if (!atPrompt(Swath.COMMAND_PROMPT)) {
                        PrintText.exec(">>>\n\nGet to the main command prompt\n\n<<<");
                        return false;
                }
                m_fighters = new Parameter("How many fighters to attack with");
                m_fighters.setType(Parameter.INTEGER);
                m_fighters.setInteger(1); 
                registerParam(m_fighters);
                
                m_numberofhits = new Parameter("Number of hits to give");
                m_numberofhits.setType(Parameter.INTEGER);
                m_numberofhits.setInteger(5);
                registerParam(m_numberofhits);

                m_ignoretrader1 = new Parameter("Trader #1 to ignore (if desired)");
                m_ignoretrader1.setType(Parameter.STRING);
                m_ignoretrader1.setString("");
                registerParam(m_ignoretrader1);

                m_ignoretrader2 = new Parameter("Trader #2 to ignore (if desired)");
                m_ignoretrader2.setType(Parameter.STRING);
                m_ignoretrader2.setString("");
                registerParam(m_ignoretrader2);
        
                m_ignoretrader3 = new Parameter("Trader #3 to ignore (if desired)");
                m_ignoretrader3.setType(Parameter.STRING);
                m_ignoretrader3.setString("");
                registerParam(m_ignoretrader3);

                m_hunttrader = new Parameter("Trader to hunt (ignoring everyone else)");
                m_hunttrader.setType(Parameter.STRING);
                m_hunttrader.setString(""); 
                registerParam(m_hunttrader);

                m_hrchoice = new Parameter("Run options for after the attack: ");                                       m_hrchoice.setType(Parameter.CHOICE);
                m_hrchoice.addChoice(0, "Remain afterwards");
                m_hrchoice.addChoice(1, "Random adjacent");
                m_hrchoice.addChoice(2, "Predefined run sector");
                m_hrchoice.setCurrentChoice(0);
                registerParam(m_hrchoice);

                m_hitandrun = new Parameter("Predefined hit and run sector (if needed)");
                m_hitandrun.setType(Parameter.INTEGER);
                m_hitandrun.setInteger(0);
                registerParam(m_hitandrun);

                m_fearic = new Parameter("Fear the Interdictor Cruiser?");
                m_fearic.setType(Parameter.BOOLEAN);
                m_fearic.setBoolean(true);
                registerParam(m_fearic);
                m_verbose = new Parameter("Be verbose?");
                m_verbose.setType(Parameter.BOOLEAN);
                m_verbose.setBoolean(true);
                registerParam(m_verbose);
                
                return true;
        }

        public boolean runScript() throws Exception {
                String str,sector,trader,shipmodel,hunttrader;
                boolean fearic, attackP, verbose;
                int i,fighters,hitandrun,hrchoice,numberofhits;
                Sector secinfo;

                //****************************************************
                //Would you like to hard-code any traders to ignore?
                //They will be ignored automatically every time you 
                //use the script....there is no need to enter their
                //names each time as a runtime parameter.
                //If so, add them to the bottom of this list,
                //You can put as many hard-coded traders in here as you want.
                //Do not worry, it will still ignore the trader names
                //that you enter as a parameter at runtime. 
                //Put a comma after each trader name that you hard-code,
                //But do not put a comma after the last trader in the list
                //****************************************************
                String[] ignoretrader={ m_ignoretrader1.getString(),  //Runtime parameter 1 
                                        m_ignoretrader2.getString(),  //Runtime parameter 2
                                        m_ignoretrader3.getString(),  //Runtime parameter 3
                                        
                                        //Hard-coded list of ignored traders goes here:
                                        
                                        "Vito Corleone",
                                        "Stein",
                                        "Your secret buddy",
                                        "Macahan"
                                        
                

                //(No need to touch code below this line)

                };
                                

                                                        
                
                Random r = new Random();
                
                                                        
                // Put the parameters into their working storage
                hunttrader=m_hunttrader.getString();
                fearic=m_fearic.getBoolean();
                hitandrun=m_hitandrun.getInteger();
                fighters=m_fighters.getInteger();
                verbose=m_verbose.getBoolean();
                hrchoice=m_hrchoice.getCurrentChoice();
                numberofhits=m_numberofhits.getInteger();

                // Check the user's hit and run input
                if ((hrchoice==2) && (hitandrun==0)) {
                        PrintText.exec("\n\n >>>Can't run to unspecified predefined sector<<< \n\n");
                        return false;
                }
                
                // Check number of hits
                if (numberofhits==0) {
                PrintText.exec("\n\n >>> WARNING!!! ZERO HITS SELECTED! <<< \n\n");
                PrintText.exec("This means you will be warping in without attacking..\n\n");
                }

                // If verbose, give the user an info screen
                if (verbose) {
                        SendString.exec("I");
                        WaitForText.exec("Command");
                }
                

                // If verbose, then tell user exactly what we are going to do
                if (verbose) {
                SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED,
                                 SetTextMode.MODE_NORMAL);
                PrintText.exec("\n\n");
                
                if (!(hunttrader.equals(""))) {
                        PrintText.exec(">>>Only hunting "+hunttrader+"<<< \n");
                }
                else {
                PrintText.exec(">>>No specific trader is being hunted exclusively<<<\n");
                }
                if (fearic) {
                        PrintText.exec(">>>Fearing the IC<<< \n");
                }
                else {
                        PrintText.exec(">>>CAUTION: NOT FEARING THE IC!<<< \n");
                }
                switch (hrchoice) {
                        case 0:
                        PrintText.exec(">>>Remaining in attack sector afterwards<<< \n");
                        break;
                        case 1:
                        PrintText.exec(">>>Running to a random adjacent sector afterwards<<< \n");
                        break;
                        case 2:
                        PrintText.exec(">>>This is a hit-and-run, running to sector "+hitandrun+" after the hit<<< \n");
                        break;
                }

                PrintText.exec(">>>Attacking with "+fighters+" fighters each hit<<< \n");
                PrintText.exec(">>>We are taking "+numberofhits+" hits<<< \n");
                

                //Display the list of ignored traders
                PrintText.exec("Ignoring the following list of traders:\n");
                for (int j=0;j<ignoretrader.length; j++) {
                        if (!ignoretrader[j].equals("")) {
                                PrintText.exec(ignoretrader[j]+"\n");
                        }
                }
                 



                }

        while (true) {

                SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED,
                                                 SetTextMode.MODE_HIGHLIGHT);
                PrintText.exec("\n\n");
                PrintText.exec("<<< Watching for trader >>>");
                PrintText.exec("\n\n");
                

                // Wait for someone to come across our toll fig...
                str=WaitForText.exec("Deployed Fighters Report Sector ");

                // Initialize the variables
                i=32;
                sector="";
                trader="";
                shipmodel="";
                attackP=true;

                // Get the sector number
                while (!(str.substring(i,i+1).equals(":"))) {
                                
                        //Grab another digit of the sector number
                        sector=sector+str.charAt(i);
                        i++;
                }
        
                i=i+2;

                // Get the trader name
                while (!(str.substring(i,i+1).equals("'"))) {

                        //Grab another letter of the trader name
                        trader=trader+str.charAt(i);
                        i++;
                }

                i=i+3;
                        
                // Get the ship model
                while (!(str.substring(i,i+8).equals(" entered"))) {
                                
                        //Grab another letter of the ship model
                        shipmodel=shipmodel+str.charAt(i);
                        i++;
                }

                if (verbose) {
                SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLUE,
                                 SetTextMode.MODE_HIGHLIGHT);   
                PrintText.exec("\n>>> "+trader+" entered sector "+sector+" <<<\n");
                PrintText.exec("\n>>> "+trader+" is driving a "+shipmodel+" <<<\n");
                }
                
                // If the trader driving an IC, and we fear it, then do not attack
                if (shipmodel.equals("Interdictor Cruiser")) {
                        if (fearic) {
                                PrintText.exec("\n>>> We fear the IC, standing down <<<\n");
                                attackP=false;  
                        }
                }

                // If we are ignoring the trader, then do not attack
                for (int j=0; j<ignoretrader.length; j++) {
                if (ignoretrader[j].equals(trader)) {
                        PrintText.exec("\n >>>Luckily for "+trader+", we are ignoring them, standing down<<<\n");
                        attackP=false;
                }
                }
                        
                // If we are hunting only a specific trader, and this is
                // not the trader we want, then do not attack
                if (!(hunttrader.equals("")) && !(hunttrader.equals(trader))) {
                        PrintText.exec("\n>>>We are only hunting "+hunttrader+", standing down<<<\n");
                        attackP=false;
                }
                        
                // If we got all the way to here and attackP is still true, 
                // the victim is attacked
                if (attackP) {
                        // TransWarps safely, or just moves if adjacent sector  
                        TransWarp.exec(Integer.parseInt(sector));

                for (int j=0; j<numberofhits ; j++) {
                        AttackTrader.exec(Swath.getTrader(trader), fighters);
                }               
                        // Here we deal with the hit-and-run setting
                        // hrchoice=0  is remain in attack sector
                        // hrchoice=1  is run to predefined sector
                        // hrchoice=2  is run to random adjacent sector
                        switch (hrchoice) {

                        case 0:  
                                //End Script!
                                SetTextMode.exec(SetTextMode.COLOR_YELLOW,
                                                 SetTextMode.COLOR_BLUE,
                                                 SetTextMode.MODE_HIGHLIGHT);
                                PrintText.exec("\n\n>>>SCRIPT IS ENDING!<<<\n");
                                return true;
                        case 1:
                                //Run to a random adjacent sector
                                secinfo = Swath.getSector(Integer.parseInt(sector));
                                Move.exec(secinfo.warpSectors()[r.nextInt(secinfo.warps())]);
                                //End script!
                                SetTextMode.exec(SetTextMode.COLOR_YELLOW,
                                                 SetTextMode.COLOR_BLUE,
                                                 SetTextMode.MODE_HIGHLIGHT);
                                PrintText.exec("\n\n>>>SCRIPT IS ENDING!<<<\n");
                                return true;    
        
                        case 2:
                                //Move to predefined sector (does not end script)
                                Move.exec(hitandrun);
                        }
                }
        }       
                 
                                 
        }

        public void endScript(boolean finished) {
        }
}