import com.swath.*;
import com.swath.cmd.*;

/**
 * Map surrounding of Sector.
 *
 * @author rem0te
 */
public class SectorMap extends UserDefinedScript {
	private Parameter m_sector;

	public String getName() {
		// Return the name of the script
		return "Map surrounding of Sector";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'sector' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().
		
		m_sector = new Parameter("Show sector");
		m_sector.setInteger(Swath.main.currSector());

		registerParam(m_sector);

		return true;
	}

	public boolean runScript() throws Exception {
		Sector root,tmp;
		int sector;
		int[] warps,tmpw;
		int i,l;

		sector = m_sector.getInteger();
		root = Swath.getSector(sector);
		warps = root.warpSectors();

		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
		PrintText.exec("\n\n"+sector+" ");
		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
		PrintText.exec("--> ");

		for(i=0;i<root.warps();i++)
		{
			tmp = Swath.getSector(warps[i]); 
			tmpw = tmp.warpSectors();
			
			if(i==0){
				SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
				PrintText.exec(warps[i]+" ");

				SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
				PrintText.exec("--> ");
				}
			else	{
				SetTextMode.exec(SetTextMode.COLOR_BLACK, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
				PrintText.exec(sector+" ");

				SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
				PrintText.exec("|-> ");

				SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
				PrintText.exec(warps[i]+" ");

				SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
				PrintText.exec("--> ");
				}
				
			for(l=0;l<tmp.warps();l++)
			{
				if(l==0){
					SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
					PrintText.exec(tmpw[l]+"\n");

					}
				else	{
					SetTextMode.exec(SetTextMode.COLOR_BLACK, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
					PrintText.exec(sector+" ");

					if(i<root.warps()-1) SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
					PrintText.exec("|   ");

					SetTextMode.exec(SetTextMode.COLOR_BLACK, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
					PrintText.exec(warps[i]+" ");

					SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
					PrintText.exec("|-> ");

					SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
					PrintText.exec(tmpw[l]+"\n");
					}
					
			}

			SetTextMode.exec(SetTextMode.COLOR_BLACK, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
			PrintText.exec(sector+" ");

			if(i<root.warps()-1) SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
			PrintText.exec("|   \n");

		}

		SendString.exec(""+SendString.RETURN_KEY);
		return true;
	}

	public void endScript(boolean finished) {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}
