import com.swath.*;
import com.swath.cmd.*;

/**
 * This script will let you move resources from one planet to another.
 *
 * Please don't delete the author info from this script least give
 * me the credit for writing this script if you are using this.
 *
 * Author: DarkOne - CEO of -=< Nav Haz Unltd >=-
 * Date: 8 Dec 2000
 * Revised: 20 May 2001 (Added non transporter functionality and comm shutoff)
 * Revised: 25 May 2001 (Added comments to alot of the code for troubleshooting)
 * Revised: 22 June 2001 (Added Transwarp functionality)
 * Revised: 5 July 2001 (Fixed & Added new functionality of the Swath API)
 * 
 * Current Version: 2.0
 */
public class ResourceMover extends UserDefinedScript {
        private Parameter m_planet1;
        private Parameter m_planet2;
        private Parameter m_sector1;
        private Parameter m_sector2;
        private Parameter m_hopsrc;
        private Parameter m_hopdest;
        private Parameter m_type;
        private Parameter m_type2;
        private Parameter m_type3;
        private Parameter m_cycles;
        private Parameter m_travel;

        public String getName() {
                return "Resource Mover";
        }

        public boolean initScript() throws Exception {
                
                //Message to all (Comment out or erase)
                //MessageBox.exec("This script is for -=- Nav Haz Unltd -=- use ONLY!", "Resource Mover", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);
                MessageBox.exec("You only need to fill in the SOURCE and TARGET fields when you are using either TRANSPORTERS/TRANSWARP, or going to a different sector other than the SOURCE sector. This is also the same for the 'Hops' fields you don't need to fill in unless you are using TRANSWARP.", "Resource Mover", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);

                //Checks too see if you are at the proper command prompt.
                if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

                //Set parameters for script
                m_sector1 = new Parameter("SOURCE sector:");
                m_sector1.setType(Parameter.INTEGER);
                m_sector1.setInteger(Swath.main.currSector());
                m_planet1 = new Parameter("Take from Planet #:");
                m_planet1.setType(Parameter.INTEGER);
                m_sector2 = new Parameter("TARGET Sector:");
                m_sector2.setType(Parameter.INTEGER);
                m_planet2 = new Parameter("Deposit onto Planet #:");
                m_planet2.setType(Parameter.INTEGER);
                m_hopsrc = new Parameter("Hops from Src to Dest:");
                m_hopsrc.setType(Parameter.INTEGER);
                m_hopdest = new Parameter("Hops from Dest to Src:");
                m_hopdest.setType(Parameter.INTEGER);
                m_type = new Parameter("Type of resources to Transfer:");
                m_type.setType(Parameter.CHOICE);
                m_type.addChoice(Swath.FUEL_ORE, "Fuel Ore");
                m_type.addChoice(Swath.ORGANICS, "Organics");
                m_type.addChoice(Swath.EQUIPMENT, "Equipment");
                m_type.addChoice(Swath.COLONISTS, "Colonists");
                m_type.setCurrentChoice(Swath.FUEL_ORE);
                m_type2 = new Parameter("Pull Colos from what Resource:");
                m_type2.setType(Parameter.CHOICE);
                m_type2.addChoice(Swath.FUEL_ORE, "Fuel Ore");
                m_type2.addChoice(Swath.ORGANICS, "Organics");
                m_type2.addChoice(Swath.EQUIPMENT, "Equipment");
                m_type2.setCurrentChoice(Swath.FUEL_ORE);
                m_type3 = new Parameter("Drop colos in which Resource:");
                m_type3.setType(Parameter.CHOICE);
                m_type3.addChoice(Swath.FUEL_ORE, "Fuel Ore");
                m_type3.addChoice(Swath.ORGANICS, "Organics");
                m_type3.addChoice(Swath.EQUIPMENT, "Equipment");

                m_type3.setCurrentChoice(Swath.FUEL_ORE);
                m_cycles = new Parameter("How many cycles to run:");
                m_cycles.setType(Parameter.INTEGER);
                m_cycles.setInteger(1);
                m_travel = new Parameter("How to move Resources:");
                m_travel.setType(Parameter.CHOICE);
                m_travel.addChoice(0, "Move InSector");
                m_travel.addChoice(1, "Transwarp");
                m_travel.addChoice(2, "Transporters");
                m_travel.addChoice(3, "Move OutSector");
                m_travel.setCurrentChoice(2);

                //Register values
                registerParam(m_sector1);
                registerParam(m_planet1);
                registerParam(m_sector2);
                registerParam(m_planet2);
                registerParam(m_hopsrc);
                registerParam(m_hopdest);
                registerParam(m_type);
                registerParam(m_type2);
                registerParam(m_type3);
                registerParam(m_cycles);
                registerParam(m_travel);

                return true;
        }

        public boolean runScript() throws Exception { 
                int counter=0;
                int fuel=0;
                int org=0;
                int equip=0;
                int colos=0;
                int holds = Swath.ship.holds();
                int from = m_type2.getCurrentChoice();
                int too = m_type3.getCurrentChoice();
                int gastoo = (3 * m_hopsrc.getInteger());
                int gasfrom = (3 * m_hopdest.getInteger());

                // Set Resource & Colonists amounts
                switch (m_type.getCurrentChoice()) {
                        case Swath.FUEL_ORE:
                                fuel=holds;
                                break;
                        case Swath.ORGANICS:
                                org=holds;
                                break;
                        case Swath.EQUIPMENT: 
                                equip=holds;
                                break;
                        case Swath.COLONISTS:
                                colos=holds;
                                break;
                }

                //Shutting off Comms & Graphics
                SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED, SetTextMode.MODE_BLINK);
                PrintText.exec("\n");
                PrintText.exec("Turning Communications and graphics off for faster performance...\n\n");
                SetTextMode.exec(SetTextMode.COLOR_MAGENTA, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);

                //Change the settings below and save and recompile if you don't want to turn these off!
                EnterComputer.exec();
                ChangePersonalSettings.exec(Swath.OFF, Swath.OFF, Swath.NO_CHANGE, Swath.NO_CHANGE, Swath.NO_CHANGE, Swath.NO_CHANGE, Swath.ON);
                LeaveComputer.exec();

                //Send secure message to corp mates - Change text of message if needed..
                SendSSRadioMessage.exec("Starting Resource Mover script. Communications have been turned off ICQ me if needed!");
        
                // Start of the Transfering Cycles
                while (true) {

                        //Cycles for Resources ONLY!
                        //Uses Transporters to move resources
                        if(m_type.getCurrentChoice() != Swath.COLONISTS){
                                if(m_travel.getCurrentChoice() == 2){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveProducts.exec(fuel, org, equip);
                                                EnterCitadel.exec();
                                                PlanetTransport.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveProducts.exec(-fuel, -org, -equip);
                                                EnterCitadel.exec();
                                                PlanetTransport.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                //Uses Transwarp to move resources
                                if(m_travel.getCurrentChoice() == 1){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveProducts.exec(gastoo, 0, 0);
                                                TakeLeaveProducts.exec(fuel, org, equip);
                                                LiftOff.exec();
                                                TransWarp.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveProducts.exec(-fuel, -org, -equip);
                                                TakeLeaveProducts.exec(gasfrom, 0, 0);
                                                LiftOff.exec();
                                                TransWarp.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                //Planets are in the same sector
                                if(m_travel.getCurrentChoice() == 0){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveProducts.exec(fuel, org, equip);
                                                LiftOff.exec();
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveProducts.exec(-fuel, -org, -equip);
                                                LiftOff.exec();
                                                counter++;
                                        }
                                }
                                //Moves Colonists to planets not in the same sector
                                if(m_travel.getCurrentChoice() == 3){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveProducts.exec(fuel, org, equip);
                                                LiftOff.exec();
                                                Move.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveProducts.exec(-fuel, -org, -equip);
                                                LiftOff.exec();
                                                Move.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                if(counter == m_cycles.getInteger()){
                                        //Send secure message to corp mates - Change text of message if needed..
                                        SendSSRadioMessage.exec("Script Finished! Re-Establishing Communication..");
                                        //Turning Comms and Graphics back on
                                        EnterComputer.exec();
                                        ChangePersonalSettings.exec(Swath.ON, Swath.ON, Swath.NO_CHANGE, Swath.NO_CHANGE,  Swath.NO_CHANGE, Swath.NO_CHANGE, Swath.OFF);
                                        LeaveComputer.exec();
                                        break;
                                }       
                        }

                        //Cycles for Colonists ONLY!
                        //Uses Transporters to move Colonists
                        if(m_type.getCurrentChoice() == Swath.COLONISTS){
                                if(m_travel.getCurrentChoice() == 2){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveColonists.exec(colos, from);
                                                EnterCitadel.exec();
                                                PlanetTransport.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveColonists.exec(-colos, too);
                                                EnterCitadel.exec();
                                                PlanetTransport.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                //Uses transwarp to move Colonists
                                if(m_travel.getCurrentChoice() == 1){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveProducts.exec(gastoo, 0, 0);
                                                TakeLeaveColonists.exec(colos, from);
                                                LiftOff.exec();
                                                TransWarp.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveColonists.exec(-colos, too);
                                                TakeLeaveProducts.exec(gasfrom, 0, 0);
                                                LiftOff.exec();
                                                TransWarp.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                //Move Colonists to planets within sector
                                if(m_travel.getCurrentChoice() == 0){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveColonists.exec(colos, from);
                                                LiftOff.exec();
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveColonists.exec(-colos, too);
                                                LiftOff.exec();
                                                counter++;
                                        }
                                }
                                //Move Colonists to planets not in the same sector
                                if(m_travel.getCurrentChoice() == 3){
                                        if(counter < m_cycles.getInteger()){
                                                Land.exec(m_planet1.getInteger());
                                                TakeLeaveColonists.exec(colos, from);
                                                LiftOff.exec();
                                                Move.exec(m_sector2.getInteger());
                                                Land.exec(m_planet2.getInteger());
                                                TakeLeaveColonists.exec(-colos, too);
                                                LiftOff.exec();
                                                Move.exec(m_sector1.getInteger());
                                                counter++;
                                        }
                                }
                                if(counter == m_cycles.getInteger()){
                                        //Send secure message to corp mates - Change text of message if needed..
                                        SendSSRadioMessage.exec("Script Finished! Re-Establishing Communication..");
                                        //Turning Comms and Graphics back on
                                        EnterComputer.exec();
                                        ChangePersonalSettings.exec(Swath.ON, Swath.ON, Swath.NO_CHANGE, Swath.NO_CHANGE,  Swath.NO_CHANGE, Swath.NO_CHANGE, Swath.OFF);
                                        LeaveComputer.exec();
                                        break;
                                }
                        }
                }
                return(true);
        }
        public void endScript(boolean finished){
        }
}