import com.swath.*;
import com.swath.cmd.*;

/**
 * Drops a planet on anyone who touches your fighters.
 *
 * <p>1.1 CHANGES:<br>
 * Provides an option to trigger only if your fighters are attacked.
 *
 * <p>Like my scripts?  Please let me know!
 *
 * @author Mongoose (krum@smyrnacable.net)
 * @version 1.1, 06 October 2001
 */
public class PlanetDrop extends UserDefinedScript {
        protected String title = "Planet Drop";
        protected String error = "Script Error";
        protected Parameter noMercyP;

public String getName() { return title; }

public boolean initScript() throws Exception {

        if(Swath.main.prompt() != Swath.CITADEL_PROMPT) {
                MessageBox.exec("You must be at the Citadel prompt.",
                        error,
                        MessageBox.ICON_ERROR,
                        MessageBox.TYPE_OK);
                        return false;
        }

        noMercyP = new Parameter("No Mercy");
        noMercyP.setType(Parameter.BOOLEAN);
        noMercyP.setBoolean(true);

        registerParam(noMercyP);

        return true;

} /* end initScript */


public boolean runScript() throws Exception {

        boolean noMercy = noMercyP.getBoolean();
        String[] messages = {"Deployed Fighters Report", "INACTIVITY"};
        String text;

        SendString.exec("P");
        while(true) {
                text = WaitForText.exec(messages);
                if(text.equals("INACTIVITY WARNING:")) {
                        SendString.exec("Q\rP");
                        continue;
                }
                else if(noMercy || text.endsWith("is attacking!")) break;
        }

        /* ahh, a victim... */
        SendString.exec(text.substring(32, text.indexOf(':')) + '\r');
        WaitForText.exec("engage?");
        SendString.exec("Y");

        return true;

} /* end runScript */


} /* end class */
