import com.swath.*;
import com.swath.cmd.*;

/**
 * Planet Buster
 *
 * @author Macahan
 */
public class PlanetBuster extends UserDefinedScript {
	private Parameter times;
	private Parameter planet;

	public String getName() {
		// Return the name of the script
		return "Planet Buster";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'times' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().
		times = new Parameter("How many times ?");
		times.setType(Parameter.INTEGER);

		planet = new Parameter("Next free planet # or 1 for no planetscanner");
		planet.setType(Parameter.INTEGER);
			
		// Register the 2 parameters
		registerParam(times);
		registerParam(planet);

		// Some other initialisation could be done here
		// ...

		return true;
	}

	public boolean runScript() throws Exception {
		int i=0;

		while(i < times.getInteger()){
			if (Swath.ship.atomicDevices()==0){
				PrintText.exec("Will have to buy more atomics in SD\n");
				if ( Swath.main.currSector() == Swath.main.stardock() ){
					PrintText.exec("Luckily we are at SD\n");  
					SendString.exec("ps");
					if (!atPrompt(Swath.STARDOCK_PROMPT)) SendString.exec("ha5\rt5\rqq");
				}
			}
			LaunchGenesisTorpedo.exec("...",Swath.PERSONAL);
			Land.exec(planet.getInteger());
			BlowUpPlanet.exec();
			i++;
		}

		return true;
	}

	public void endScript(boolean finished) {
	}
}
