import com.swath.*;
import com.swath.cmd.*;

/**
 * PhotonWatch by Zandramus.. will start density scaning from the current sector
 * if the density changes in any of the surrounding sectors it fires a photon
 * to that sector you must have at least a density scanner and a photon miseile
 * this script will hit anyone who enters you corpies too! so there is a warning
 * sent on subspace as that your photon watch is active in xxx sector... do not
 * enter any of the surrounding sectors.
 *
 * Author CSG aka Zandramus jmelsone@insight.rr.com
 * Version 1.0.0
 */
public class PhotonWatch extends UserDefinedScript {
	private Parameter mygate;

	public String getName() {
		// Return the name of the script
		return "PhotonWatch";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// The following does nothing but add a parameter to allow the
		// script to execute... has been disguised as a delay but is
		// totally non functional

		mygate = new Parameter("Delay in Seconds");
		mygate.setType(Parameter.INTEGER);

		registerParam(mygate);

		return true;
	}

	public boolean runScript() throws Exception {
		int prevscan [] = Swath.sector.warpSectors();
		int currscan [] = Swath.sector.warpSectors();
		boolean j = true;
		int i;

		SendSSRadioMessage.exec("Starting Photon Watch do not enter any of my adjacent sectors");
		Sector currsector = Swath.getSector(Swath.sector.sector());
		int iWarps[] = Swath.sector.warpSectors();

		ScanSector.exec(ScanSector.DENSITY_SCAN);

		// Initialise first scan
		for (i=0; i < Swath.sector.warps(); i++) {
			prevscan[i] = Swath.getSector(iWarps[i]).density();
			currscan[i] = Swath.getSector(iWarps[i]).density();
		}

        // Start watch
		while (j == true) {
			ScanSector.exec(ScanSector.DENSITY_SCAN);
			for (i=0; i < Swath.sector.warps(); i++) {
				currscan[i] = Swath.getSector(iWarps[i]).density();
				if (currscan[i] != prevscan[i]) {
					EnterComputer.exec();
					FirePhotonMissile.exec(iWarps[i]);
					LeaveComputer.exec();
					j = false;
				}
			}
		}

		return true;
	}

	public void endScript(boolean finished) {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}
