import com.swath.*;
import com.swath.cmd.*;

/**
 * This is my first SWATH script.
 * It shoots a photon then moves your ship after into the sector.
 *
 * @author Macahan
 */
public class PhotonMove extends UserDefinedScript {
	private Parameter sector;

	public String getName() {
		// Return the name of the script
		return "Photon Move";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'sector' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().
		sector = new Parameter("Photon what sector!");
		sector.setInteger(Swath.main.currSector());
		
		// Register the sector number  
		registerParam(sector);
		
		// Some other initialisation could be done here
		// ...

		return true;
	}

	public boolean runScript() throws Exception {
		// check if we really got a photon on us! first update 
		// trader info so we are sure we got good values!
		SendString.exec("i");
		// Wait for prompt to avoid out of sync problem
		WaitForText.exec("Command [TL=00:00:00]:[");	
		// ok let's check... if we don't have any abort!
		if (Swath.ship.photonMissiles()==0){
			PrintText.exec("\nBoozoo you need a photon missle!\n");
			return false;
		}
		// enter computer to fire photon missle
		EnterComputer.exec();
		// to quicken up movement speed disable ansi 
		// and animations we assume it's turned on.
		String x;
		// enter ansi and misc settings menu
		SendString.exec("n");
		// Read the line with ANSI graphics settings
		x = WaitForText.exec("ANSI graphics");
		// If we got ANSI graphics on disable to disable both animation and ansi
		if ( x.compareTo("(1) ANSI graphics            - On ") == 0){
			SendString.exec("1");
		}
		// quit the ANSI and misc settings menu
		SendString.exec("q");
		// Wait for prompt to avoid out of sync problem
		WaitForText.exec("Computer command [TL=00:00:00]:");
		// ok ready!! Fire in the hole!!!
		FirePhotonMissile.exec(sector.getInteger());
		// leave computer menu
		LeaveComputer.exec();
		// Charge!!!!!! RIDE ON THE WAVE!!
		Move.exec(sector.getInteger());
		// End of script
		return true;
	}

	public void endScript(boolean finished) {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}
