import com.swath.*;
import com.swath.cmd.*;

/**
 *  Move Explore version 1.0.0
 *  
 *  Alvar 04/18/2001
 *  
 *  Designed for Game Day 1 exploring.
 *  Later versions will offer better avoid parameters, trade at ports,
 *  drop figs/mines, and auto-PPT
 */
public class MoveExplore1 extends UserDefinedScript {
	public String getName() {
		return "Move Explore V 1.0.0";
	}
	private Parameter aCount;
	public boolean initScript() throws Exception {
		if (!atPrompt (Swath.COMMAND_PROMPT)) return false;
		boolean aDensScan = Swath.ship.hasDensityScanner();
		if (aDensScan == false) {
			PrintText.exec("Not safe to run without a density scanner.");
			return false;
		}
		aCount = new Parameter ("# of Sectors Exploring");
		aCount.setType(Parameter.INTEGER);
		registerParam(aCount);
		return true;
	}
	public boolean runScript() throws Exception {
		boolean aHoloScan = Swath.ship.hasHoloScanner();
		int aTotSectors = Swath.main.sectors();
		int aClearData=0;
		int aMovesLeft=0;
		int[] aTempUnex;
		aTempUnex = new int[6];
		int[] aWarpSec;
		aWarpSec = new int[6];
		int aCurSec = Swath.ship.sector();
		Sector aSector;
		int aWarps;
		int aWarpCounter;
		int aAdjSect;
		int aSectorCheck;
		Sector aAdjSectInfo = Swath.getSector(aCurSec);
		int aSecVisCount=0;
		int aUnexCount=0;
		int aVoidCount=0;
		int aBiggestArray=0;
		int aPrevCheck=0;
		int[] aSectorsVisited;
		aSectorsVisited = new int[aTotSectors];
		int[] aUnexploredSectors;
		aUnexploredSectors = new int[aTotSectors];
		int[] aVoidedSectors;
		aVoidedSectors = new int[aTotSectors];
		int aArrayInt;
		int aTempUnexCount=0;
		int scanCount=0;
		Sector scanInfo;
		int findNextMove=1;
		int aNextSector=0;
		int removeSect=0;
		for (aArrayInt=0; aArrayInt < aTotSectors; aArrayInt++) {
			aSectorsVisited[aArrayInt]=0;
			aUnexploredSectors[aArrayInt]=0;
			aVoidedSectors[aArrayInt]=0;
		}
		while (aMovesLeft <= aCount.getInteger()) {
			for (aClearData=0; aClearData<6; aClearData++) {
				aWarpSec[aClearData]=0;
				aTempUnex[aClearData]=0;
			}
			aCurSec = Swath.ship.sector();
			for (removeSect=0; removeSect < aUnexCount; removeSect++) {
				if (aUnexploredSectors[removeSect] == aCurSec) {
					aUnexploredSectors[removeSect]=0;
					aUnexCount++;
					aSectorsVisited[aSecVisCount] = aCurSec;
					break;
				}
			}
			aSector = Swath.getSector(aCurSec);
			aWarps = aSector.warps();
			aWarpCounter = aWarps;
			for (aAdjSect=0; aAdjSect < aWarpCounter; aAdjSect++) {
				aWarpSec[aAdjSect] = aSector.warpSectors()[aAdjSect];
			}
			for (aSectorCheck=0; aSectorCheck < aWarpCounter; aSectorCheck++) {
				aAdjSectInfo = Swath.getSector(aWarpSec[aSectorCheck]);
				if (aSecVisCount >= aUnexCount) {
					if (aSecVisCount >= aVoidCount) {
						aBiggestArray = aSecVisCount;
					} else {
						aBiggestArray = aVoidCount;
					}
				} else if (aUnexCount >= aVoidCount) {
					aBiggestArray = aUnexCount;
				} else {
					aBiggestArray = aVoidCount;
				}
				for (aPrevCheck=0; aPrevCheck <= aBiggestArray; aPrevCheck++) {
					if (aSectorsVisited[aPrevCheck] == aWarpSec[aSectorCheck]) {
						aWarpSec[aSectorCheck]=0;
					} else if (aUnexploredSectors[aPrevCheck] == aWarpSec[aSectorCheck]) {
						aWarpSec[aSectorCheck]=0;
					} else if (aVoidedSectors[aPrevCheck] == aWarpSec[aSectorCheck]) {
						aWarpSec[aSectorCheck]=0;
					}
				}
				if (aWarpSec[aSectorCheck]==0) {
				} else if (aAdjSectInfo.isUnexplored() == false) {
					aSectorsVisited[aSecVisCount] = aWarpSec[aSectorCheck];
					aSecVisCount++;
				} else {
					aTempUnex[aTempUnexCount] = aWarpSec[aSectorCheck];
					aTempUnexCount++;
				}
			}
			ScanSector.exec(0);
			if (aHoloScan == true) {
				ScanSector.exec(1);
			}
			for (scanCount=0; scanCount < aTempUnexCount; scanCount++) {
				if (aTempUnex[scanCount] == 0){
				} else {
				scanInfo = Swath.getSector(aTempUnex[scanCount]);
				if (aTempUnex[scanCount]==0) {
				} else if (scanInfo.anomality() == true) {
					aVoidedSectors[aVoidCount] = aTempUnex[scanCount];
					aVoidCount++;
				} else if (scanInfo.navHaz() != 0) {
					aVoidedSectors[aVoidCount] = aTempUnex[scanCount];
					aVoidCount++;
				} else{
					if (scanInfo.density() == 0) {
						aUnexploredSectors[aUnexCount] = aTempUnex[scanCount];
						aUnexCount++;
						aNextSector = aTempUnex[scanCount];
					} else if (scanInfo.density() == 1) {
						aUnexploredSectors[aUnexCount] = aTempUnex[scanCount];
						aUnexCount++;
						aNextSector = aTempUnex[scanCount];
					} else if (scanInfo.density() == 100) {
						aUnexploredSectors[aUnexCount] = aTempUnex[scanCount];
						aUnexCount++;
						aNextSector = aTempUnex[scanCount];
					} else if (scanInfo.density() == 101) {
						aUnexploredSectors[aUnexCount] = aTempUnex[scanCount];
						aUnexCount++;
						aNextSector = aTempUnex[scanCount];
					} else {
						aVoidedSectors[aVoidCount] = aTempUnex[scanCount];
						aVoidCount++;

							
							}
						}
					}
				}
				if (aNextSector == 0) {
					for (findNextMove = aUnexCount; findNextMove >=0; findNextMove--) {
						if (aUnexploredSectors[findNextMove] != 0) {
							aNextSector = aUnexploredSectors[findNextMove];
							aUnexploredSectors[findNextMove]=0;
							break;
						}
					}
				} else if (aNextSector == aCurSec) {
					for (findNextMove = aUnexCount; findNextMove >=0; findNextMove--) {
						if (aUnexploredSectors[findNextMove] != 0) {
							aNextSector = aUnexploredSectors[findNextMove];
								aUnexploredSectors[findNextMove]=0;
							break;
						}
					}
				}
				if (aNextSector == 0) {
					PrintText.exec("Ran out of unexplored sectors.");
					return false;
				}
				Move.exec(aNextSector);
				aMovesLeft++;
			}
		return true;
		}
	public void endScript (boolean finished) {
	}
}
