import com.swath.*;
import com.swath.cmd.*;

/**
 * Mine Disruptor Script
 * 
 * This script automates the process of removing enemy mines from a sector.
 *
 * Please don't delete the author info from this script least give
 * me the credit for writing this script if you are using this.
 * 
 * Author: DarkOne - CEO of -=<Nav Haz Unltd. >=-
 * Date: 7 Dec 2000
 * Updated: 8 July 2001 (Updated to new API)
 * 
 * Version: 1.1
 */
public class MineDisrup extends UserDefinedScript {
        private Parameter m_sector;

        public String getName() {
                return "Disrupt Mines";
        }

        public boolean initScript() throws Exception {
                
                //Message to all
                MessageBox.exec("This script will remove mines from a adjacent sector.", "Disrupt Mines in Sector", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);   

                if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

                m_sector = new Parameter("The Sector to remove mines from?");
                m_sector.setType(Parameter.INTEGER);

                registerParam(m_sector);

                return true;
        }

        public boolean runScript() throws Exception {
                //Updates all values of the ship
                SendString.exec("i");
                
                while (true){
                        if(Swath.getSector(m_sector.getInteger()).armidMines() >= 1){
                                if(Swath.ship.mineDisruptors() > 0){
                                        EnterComputer.exec();
                                        LaunchMineDisruptor.exec(m_sector.getInteger());
                                        LeaveComputer.exec();
                                }
                                if(Swath.ship.mineDisruptors() == 0){
                                MessageBox.exec("You are out of Mine Disruptors. Goto StarDock and get more to continue with removal.", "Out of Disruptors", MessageBox.ICON_STOP, MessageBox.TYPE_OK);
                                break;
                                }
                        }
                        if(Swath.getSector(m_sector.getInteger()).armidMines() == 0){
                                SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED, SetTextMode.MODE_BLINK);
                                PrintText.exec("\n");
                                PrintText.exec("All Armid Mines have been removed from "+m_sector.getInteger()+". Script Complete!\n\n");
                                SetTextMode.exec(SetTextMode.COLOR_MAGENTA, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
                                break;
                        }       
                }
				return true;
        }

		public void endScript(boolean finished) {
        }
}