import com.swath.*;
import com.swath.cmd.*;

/**
 * Mega Dump v.1.0.0 k
 *
 * This script is a variation of the megajettison.
 * It is still designed primarily for experience-gathering
 * for evils.  But it gives the option of once the holds are
 * full to jettison, sell to another port, or dump on a planet.
 *
 * @author Alvar  03/31/2001
 */
public class MegaDump extends UserDefinedScript {

 // set up input variables

 private Parameter afuel;
 private Parameter aorg;
 private Parameter aequip;
 private Parameter adowhat;
 private Parameter asector2;
 private Parameter aplanet;
 private Parameter amovehow;
 private Parameter acycles;



 public String getName() {
  return "Mega Dump v.1.0.0";
 }

 public boolean initScript() throws Exception {

  if (!atPrompt (Swath.COMMAND_PROMPT)) return false;

  afuel = new Parameter("Amount of fuel");
  afuel.setType(Parameter.INTEGER);
  aorg = new Parameter("Amount of organics");
  aorg.setType(Parameter.INTEGER);
  aequip = new Parameter("Amount of equipment");
  aequip.setType(Parameter.INTEGER);

  adowhat = new Parameter("Do what with products?");
  adowhat.setType(Parameter.CHOICE);
  adowhat.addChoice(0, "Jettison");
  adowhat.addChoice(1, "Sell");
  adowhat.addChoice(2, "Dump on a planet");
  adowhat.setCurrentChoice(0);

  asector2 = new Parameter("Which sector to leave products (0 for same sector");
  asector2.setType(Parameter.INTEGER);
  asector2.setInteger(Swath.ship.sector());

  aplanet = new Parameter("What is the planet #? (0 for no planet");
  aplanet.setType(Parameter.INTEGER);

  amovehow = new Parameter("How do you want to move?");
  amovehow.setType(Parameter.CHOICE);
  amovehow.addChoice(0, "We ain't goin' anywhere!!");
  amovehow.addChoice(1, "Just move there, & move back.");
  amovehow.addChoice(2, "Twarp there and back.");
  amovehow.addChoice(3, "Twarp there and planet transport back.(Dump on planet only)");
  amovehow.setCurrentChoice(0);

  acycles = new Parameter("How many full holds you going to buy?");
  acycles.setType(Parameter.INTEGER);

  registerParam(afuel);
  registerParam(aorg);
  registerParam(aequip);
  registerParam(adowhat);
  registerParam(asector2);
  registerParam(aplanet);
  registerParam(amovehow);
  registerParam(acycles);

  return true;
 }

 public boolean runScript() throws Exception {
  int fuel=0;
  int org=0;
  int equip=0;
  int eholds = Swath.ship.emptyHolds();
  int abuy=0;
  int aportsector = Swath.ship.sector();
  int atotalholds = Swath.ship.holds();
  int afuel1=0;
  int afuel2=0;
  int afuelsave=0;
  int afuelsell=0;
  int i=0;
  int aorgsell=0;
  int aequipsell=0;

  while (i <= acycles.getInteger()) {

   JettisonCargo.exec(); //clears holds
   fuel=afuel.getInteger();
   org=aorg.getInteger();
   equip=aequip.getInteger();
   abuy=fuel+org+equip;
   eholds = Swath.ship.emptyHolds();

    while (abuy <= eholds) {

     Trade.exec(fuel, org, equip);
     eholds = Swath.ship.emptyHolds();

    }

   i++;

   switch (adowhat.getCurrentChoice()) {

    case 0:

     break;
     

    case 1:

     switch (amovehow.getCurrentChoice()) {

      case 1:

       Move.exec(asector2.getInteger());
       afuelsell = Swath.ship.fuel();
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
       Trade.exec(-afuelsell, -aorgsell, -aequipsell);
       Move.exec(aportsector);
       eholds = Swath.ship.emptyHolds();
       break;

      case 2:

         afuel1 = Swath.ship.fuel();
         TransWarp.exec(asector2.getInteger());
         afuel2 = Swath.ship.fuel();
         afuelsell=2*afuel2-afuel1;
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
       Trade.exec(-afuelsell, -aorgsell, -aequipsell);
       TransWarp.exec(aportsector);
       eholds = Swath.ship.emptyHolds();
        break;      

     }
     break;

    case 2:

     switch (amovehow.getCurrentChoice()) {

      case 0:

       afuelsell = Swath.ship.fuel();
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
       Land.exec(aplanet.getInteger());
       TakeLeaveProducts.exec(-afuelsell, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, 0, -aequipsell);
       LiftOff.exec();
       eholds = Swath.ship.emptyHolds();
       break;

      case 1:

       Move.exec(asector2.getInteger());
       afuelsell = Swath.ship.fuel();
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
       Land.exec(aplanet.getInteger());
       TakeLeaveProducts.exec(-afuelsell, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, 0, -aequipsell);
       LiftOff.exec();
       Move.exec(aportsector);
       eholds = Swath.ship.emptyHolds();
       break;

      case 2:

         afuel1 = Swath.ship.fuel();
         TransWarp.exec(asector2.getInteger());
         afuel2 = Swath.ship.fuel();
         afuelsell=2*afuel2-afuel1;
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
         Land.exec(aplanet.getInteger());
       TakeLeaveProducts.exec(-afuelsell, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, 0, -aequipsell);
       LiftOff.exec();
       TransWarp.exec(aportsector);
       eholds = Swath.ship.emptyHolds();
       break;

      case 3:

         afuel1 = Swath.ship.fuel();
         TransWarp.exec(asector2.getInteger());
         afuel2 = Swath.ship.fuel();
         afuelsell=2*afuel2-afuel1;
       afuelsell = Swath.ship.fuel();
       aorgsell = Swath.ship.organics();
       aequipsell = Swath.ship.equipment();
              Land.exec(aplanet.getInteger());
       TakeLeaveProducts.exec(-afuelsell, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, -aorgsell, -aequipsell);
       TakeLeaveProducts.exec(0, 0, -aequipsell);
       EnterCitadel.exec();
       PlanetTransport.exec(aportsector);
       break;

     }
     break;
    }

   }

  return true;
 }

 public void endScript(boolean finished) {
 }
}
