import com.swath.*;
import com.swath.cmd.*;

/**
 * This is my first SWATH script. It uses port
 * and fighter info to locate enemy forces.
 *
 * @author StevoD
 */
public class LocateEnemies extends UserDefinedScript {

	
	private Parameter m_maxProd;
	private Parameter m_maxPerc;
	
	public String getName() {
		// Return the name of the script
		return "Locate Enemy Forces";
	}

	public boolean initScript() throws Exception {
		
		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;
		
		m_maxProd = new Parameter("Max Product Level");
		m_maxProd.setType(Parameter.INTEGER);
		m_maxProd.setInteger(300);
		m_maxPerc = new Parameter("Max Percentage Level");
		m_maxPerc.setType(Parameter.INTEGER);
		m_maxPerc.setInteger(25);		


		registerParam(m_maxProd);
		registerParam(m_maxPerc);
			

		return true;
	}

	public boolean runScript() throws Exception {
		Sector sector;
		int loop;
		int[] product;
	 	int[] percentages;
		boolean check = false;

		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED,
			SetTextMode.MODE_HIGHLIGHT);
		for (loop = 11; loop <= Swath.main.sectors(); loop++)
		{
			sector = Swath.getSector(loop);
			if (sector.portStatus() == Sector.PORT_AVAILABLE &&
			    sector.portClass() != 0 && sector.fighters() == 0)
			{
				
				product = sector.portAmounts();
				percentages = sector.portPercentages();
				
					
			
					if (product[Swath.FUEL_ORE] < m_maxProd.getInteger())
						check = true;
					else if (product[Swath.ORGANICS] < m_maxProd.getInteger())
						check = true;
					else if (product[Swath.EQUIPMENT] < m_maxProd.getInteger())
						check = true;
					else if (percentages[Swath.FUEL_ORE] < m_maxPerc.getInteger())
						check = true;
					else if (percentages[Swath.ORGANICS] < m_maxPerc.getInteger())
						check = true;
					else if (percentages[Swath.EQUIPMENT] < m_maxPerc.getInteger())
						check = true;
				
			}
			if (check == true)
				PrintText.exec("Sector "+loop+" may contain enemy forces.\n");		
			check = false;	
		}				
		
		return true;
	}

	public void endScript(boolean finished) {

	}
}
