import com.swath.*;
import com.swath.cmd.*;

/** 
 * This script will drain a sector of limpets. All you have to do is go into a sector
 * with more than one and run this script. It will pick up the limpets by logging you
 * in and out of the game. This way you pick up a limpet each time and you don't use
 * any turns :)
 *
 * Or you can use this script to help you while invading. Could use to help drain Qcannons/
 * Interdictor planets of Ore as well.
 *
 * Please don't delete the author info from this script least give
 * me the credit for writing this script if you are using this.
 *
 * Author: DarkOne - CEO of -=< Nav Haz Unltd >=-
 * Date: 10 may 2001
 * Updated: 20 June 2001 (Added the clearing of Limpets at SD)
 * Updated: 6 July 2001 (Added new API functions i.e: password logins & SD dockings)
 *
 * Version: 2.0
 */
public class LimpetClear extends UserDefinedScript {
        private Parameter m_cycles;
        private Parameter m_clear;
        private Parameter m_switch;
        private Parameter m_password;      

        public String getName() {
                // Return the name of the script
            return "Clear Limpets";
        }

        public boolean initScript() throws Exception {
        
        MessageBox.exec("REMEMBER: If you don't select 'Clear Limpets' you have to goto SD and clear them yourself.", "Clear Limpets", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);
        
        // Check that we are at the correct prompt
        if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

        // Define layout & values of User Interface
                m_cycles = new Parameter("Number of times to pick up:");
                m_cycles.setType(Parameter.INTEGER);
                m_cycles.setInteger(2);
                m_switch = new Parameter("Does TW have a PW login?");
                m_switch.setType(Parameter.BOOLEAN);
                m_switch.setBoolean(false);
                m_password = new Parameter("Enter PW if needed:");
                m_password.setType(Parameter.STRING);
                m_clear = new Parameter("Clear off Limpets when done?");
                m_clear.setType(Parameter.BOOLEAN);
                m_clear.setBoolean(false);

        //Register Paramters
                registerParam(m_cycles);
                registerParam(m_switch);
                registerParam(m_password);
                registerParam(m_clear);

        return true;
        }

        public boolean runScript() throws Exception {
                // Counter to keep track of number of cycles completed  
                        int counter = 1;                

                //Start script          
                while (counter <= m_cycles.getInteger()){
                        //ReEnter game without password
                        if(m_switch.getBoolean() == false){                               
                                ReEnterTW.exec();
                        }
                        //ReEnter game with password
                        if(m_switch.getBoolean() == true){
                                ReEnterTW.exec(m_password.getString());
                        }
                        if(counter == m_cycles.getInteger()){
                                if (m_clear.getBoolean() == true){
                                        PrintText.exec("\n");
                                        PrintText.exec("Warping too StarDock to clear Limpets.");
                                        PrintText.exec("\n");
                                        TransWarp.exec(Swath.main.stardock());
                                        LandOnStarDock.exec();
                                        SendString.exec(SendString.RETURN_KEY);
                                        LeaveStarDock.exec();
                                        MessageBox.exec("All Limpets have been cleared from your ship.", "Clear Limpets", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);
                                }
                        }
                counter++;
                }       
                return true;                    
        }

        public void endScript(boolean finished) {
                // Do some clean up here if necessary.
                // Remember: In Java you don't need to free any memory
                // since all memory is garbage collected when not used.
        }
}