/*
 * ISResMover - InterSector Resource Mover
 *
 * Author  : Silent Rain <srain303@hushmail.com>
 * Version : 1.0.9
 * Date    : 03/13/2001 12:28 MST
 *
 */

import com.swath.*;
import com.swath.cmd.*;

public class ISResMover extends UserDefinedScript {
   private Parameter m_srcSec;
   private Parameter m_destSec;
   private Parameter m_srcPl;
   private Parameter m_destPl;
   private Parameter m_srcFuel;
   private Parameter m_srcOrgs;
   private Parameter m_srcEquip;
   private Parameter m_srcCols;
   private Parameter m_srcColsFrom;
   private Parameter m_destColsTo;
   private Parameter m_srcMoveVia;
   private Parameter m_destMoveVia;
   private Parameter m_numHopsToDest;
   private Parameter m_numHopsToSrc;

   public String getName() {
      return "ISResMover v1.0.9 [srain]";
   }

   public boolean initScript() throws Exception {
      // Ensure we are at the right prompt.
      if (!atPrompt(Swath.PLANET_PROMPT)) return false;

      // Set the parameters.
      m_srcSec = new Parameter("Source sector: ");
      m_srcSec.setType(Parameter.INTEGER);
      m_srcSec.setInteger(Swath.main.currSector());
      m_srcSec.setIntegerRange(1,5000);    
      m_destSec = new Parameter("Destination sector: ");
      m_destSec.setType(Parameter.INTEGER);
      m_destSec.setInteger(Swath.main.currSector());
      m_destSec.setIntegerRange(1,5000);
      m_srcPl = new Parameter("Source planet #: ");
      m_srcPl.setType(Parameter.INTEGER);
      m_destPl = new Parameter("Destination planet #: ");
      m_destPl.setType(Parameter.INTEGER);

      m_srcFuel = new Parameter("Fuel Ore: ");
      m_srcFuel.setType(Parameter.DOUBLE);
      m_srcFuel.setDouble(0);
      m_srcOrgs = new Parameter("Organics: ");
      m_srcOrgs.setType(Parameter.DOUBLE);
      m_srcOrgs.setDouble(0);
      m_srcEquip = new Parameter("Equipment: ");
      m_srcEquip.setType(Parameter.DOUBLE);
      m_srcEquip.setDouble(0);
      m_srcCols = new Parameter("Colonists: ");
      m_srcCols.setType(Parameter.DOUBLE);
      m_srcCols.setDouble(0);

      m_srcColsFrom = new Parameter("Move colonists from: ");
      m_srcColsFrom.setType(Parameter.CHOICE);
      m_srcColsFrom.addChoice(Swath.FUEL_ORE, "Fuel Ore");
      m_srcColsFrom.addChoice(Swath.ORGANICS, "Organics");
      m_srcColsFrom.addChoice(Swath.EQUIPMENT, "Equipment");
      m_srcColsFrom.setCurrentChoice(Swath.FUEL_ORE);

      m_destColsTo = new Parameter("Move colonists to: ");
      m_destColsTo.setType(Parameter.CHOICE);
      m_destColsTo.addChoice(Swath.FUEL_ORE, "Fuel Ore");
      m_destColsTo.addChoice(Swath.ORGANICS, "Organics");
      m_destColsTo.addChoice(Swath.EQUIPMENT, "Equipment");
      m_destColsTo.setCurrentChoice(Swath.FUEL_ORE);

      m_srcMoveVia = new Parameter("Move to destination via: ");
      m_srcMoveVia.setType(Parameter.CHOICE);
      m_srcMoveVia.addChoice(0, "Move");
      m_srcMoveVia.addChoice(1, "Transwarp");
      m_srcMoveVia.setCurrentChoice(1);

      m_destMoveVia = new Parameter("Move from destination via: ");
      m_destMoveVia.setType(Parameter.CHOICE);
      m_destMoveVia.addChoice(0, "Move");
      m_destMoveVia.addChoice(1, "Transwarp");
      m_destMoveVia.setCurrentChoice(1);

      m_numHopsToDest = new Parameter("Hops to destination sector: ");
      m_numHopsToDest.setType(Parameter.INTEGER);
      m_numHopsToDest.setInteger(0);
      m_numHopsToDest.setIntegerRange(0,40);

      m_numHopsToSrc = new Parameter("Hops to source sector: ");
      m_numHopsToSrc.setType(Parameter.INTEGER);
      m_numHopsToSrc.setInteger(0);
      m_numHopsToSrc.setIntegerRange(0,40);

      // Register parameters.      
      registerParam(m_srcSec);
      registerParam(m_destSec);
      registerParam(m_srcPl);
      registerParam(m_destPl);
      registerParam(m_srcFuel);
      registerParam(m_srcOrgs);
      registerParam(m_srcEquip);
      registerParam(m_srcCols);
      registerParam(m_srcColsFrom);
      registerParam(m_destColsTo);
      registerParam(m_srcMoveVia);
      registerParam(m_destMoveVia);
      registerParam(m_numHopsToDest);
      registerParam(m_numHopsToSrc);

      // Return success.
      return true;
   }

   public boolean runScript() throws Exception {
      int emptyHolds;
      double remainFuel;
      double remainOrgs;
      double remainEquip;
      double remainCols;
      int totTwarpFuel;
      boolean twarp;
      double toTakeFuel;
      double toTakeOrgs;
      double toTakeEquip;
      double toTakeCols;
      int availHolds;

      // Initialize local variables.
      emptyHolds = Swath.ship.emptyHolds();
      remainFuel = m_srcFuel.getDouble();
      remainOrgs = m_srcOrgs.getDouble();
      remainEquip = m_srcEquip.getDouble();
      remainCols = m_srcCols.getDouble();

      totTwarpFuel = 0;
      if(m_srcMoveVia.getCurrentChoice() == 1) {
         totTwarpFuel = 3 * m_numHopsToDest.getInteger();
      }
      if(m_destMoveVia.getCurrentChoice() == 1) {
         totTwarpFuel = totTwarpFuel + (3 * m_numHopsToSrc.getInteger());
      }
      twarp = (totTwarpFuel > 0);

      while ((remainFuel > 0) || (remainOrgs > 0) || (remainEquip > 0) || (remainCols > 0)) {
         // Clear the vars
            toTakeFuel = 0;
            toTakeOrgs = 0;
            toTakeEquip = 0;
            toTakeCols = 0;
            availHolds = emptyHolds - totTwarpFuel;

         // Load the holds.
         if(remainFuel > 0) {
            if(remainFuel <= availHolds) {
               toTakeFuel = toTakeFuel + remainFuel;
               availHolds = availHolds - (int)remainFuel;
               remainFuel = 0;
            } else {
               toTakeFuel = toTakeFuel + availHolds;
               remainFuel = remainFuel - availHolds;
               availHolds = 0;
            }
         }
         if(remainOrgs > 0) {
            if(remainOrgs <= availHolds) {
               toTakeOrgs = remainOrgs;
               availHolds = availHolds - (int)remainOrgs;
               remainOrgs = 0;
            } else {
               toTakeOrgs = toTakeOrgs + availHolds;
               remainOrgs = remainOrgs - availHolds;
               availHolds = 0;
            }
         }
         if(remainEquip > 0) {                   
            if(remainEquip <= availHolds) {
               toTakeEquip = remainEquip;
               availHolds = availHolds - (int)remainEquip;
               remainEquip = 0;
            } else {
               toTakeEquip = toTakeEquip + availHolds;
               remainEquip = remainEquip - availHolds;
               availHolds = 0;
            }
         }

		// Ensure that we are at least taking one of the above before loading.
        if ((toTakeFuel + toTakeOrgs + toTakeEquip + totTwarpFuel) > 0) {
           if ((toTakeFuel + totTwarpFuel) > 0) {
              TakeLeaveProducts.exec((int)toTakeFuel + totTwarpFuel, 0, 0);
           }
           if (toTakeOrgs > 0) {
           TakeLeaveProducts.exec(0, (int)toTakeOrgs, 0);
           }
           if (toTakeEquip > 0) {
           TakeLeaveProducts.exec(0, 0, (int)toTakeEquip);
           }
        }

        if(availHolds > 0) {
            if(remainCols <= availHolds) {
               toTakeCols = remainCols;
               availHolds = availHolds - (int)remainCols;
               remainCols = 0;
            } else {
               toTakeCols = toTakeCols + availHolds;
               remainCols = remainCols - availHolds;
               availHolds = 0;
            }
        }

        // Ensure that we are taking at least 1 colonist before grabbing them.
        if(toTakeCols > 0) {
           TakeLeaveColonists.exec((int)toTakeCols, m_srcColsFrom.getCurrentChoice());
        }
        
        // Lift off of the planet
        LiftOff.exec();

        // Move to destination sector
        if(m_srcMoveVia.getCurrentChoice() == 1) {
           TransWarp.exec(m_destSec.getInteger());
        } else {
           Move.exec(m_destSec.getInteger());
        }

        // Land on the destination planet
        Land.exec(m_destPl.getInteger());

        // Unload holds and colonists.
        if((toTakeFuel + toTakeOrgs + toTakeEquip) > 0) {
           if(toTakeFuel > 0) {
              TakeLeaveProducts.exec((int)toTakeFuel*-1, 0, 0);
           }
           if(toTakeOrgs > 0) {
              TakeLeaveProducts.exec(0, (int)toTakeOrgs*-1, 0);
           }
           if(toTakeEquip > 0) {
              TakeLeaveProducts.exec(0,0, (int)toTakeEquip*-1);
           }
        }
        if(toTakeCols > 0) {
           TakeLeaveColonists.exec((int)toTakeCols * -1, m_destColsTo.getCurrentChoice());
        }

        if((remainFuel > 0) || (remainOrgs > 0) || (remainEquip > 0) || (remainCols > 0)) {
           // Lift off of the planet.
           LiftOff.exec();

           // Move to src sector
           if(m_destMoveVia.getCurrentChoice() == 1) {
              TransWarp.exec(m_srcSec.getInteger());
           } else {
              Move.exec(m_srcSec.getInteger());
           }

           // Land on source planet.
           Land.exec(m_srcPl.getInteger());
         }
      }

      // Let everyone know we are cool.
      PrintText.exec("ISResMover v1.0.9 [srain]: Completed successfully!");
      return true;
   }

   public void endScript(boolean finished) {
   }
}
