import com.swath.*;
import com.swath.cmd.*;

/**
 * "ISGrabSell" script.
 *
 * @author Severian
 * Modifies to include intersector selling
 */
public class ISGrabSell extends UserDefinedScript {
        private Parameter m_sector;
        private Parameter m_planet;
        private Parameter m_type;
        private Parameter m_sector2;

        public String getName() {
                return "ISGrabSell";
        }

        public boolean initScript() throws Exception {

				MessageBox.exec("This script was made for The Trade Warriors Alliance",
								"ISGrabSell", MessageBox.ICON_INFORMATION, MessageBox.TYPE_OK);

                if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

                m_sector = new Parameter("Starting Sector");
                m_sector.setType(Parameter.INTEGER);
                m_planet = new Parameter("Grab from planet");
                m_planet.setType(Parameter.INTEGER);
                m_type = new Parameter("Type of product to grab and sell");
                m_type.setType(Parameter.CHOICE);
                m_type.addChoice(Swath.FUEL_ORE, "Fuel Ore");
                m_type.addChoice(Swath.ORGANICS, "Organics");
                m_type.addChoice(Swath.EQUIPMENT, "Equipment");
                m_type.setCurrentChoice(Swath.FUEL_ORE);
                m_sector2 = new Parameter("Trade Sector");
                m_sector2.setType(Parameter.INTEGER);

                registerParam(m_sector);
                registerParam(m_sector2);
                registerParam(m_planet);
                registerParam(m_type);

                return true;
        }

        public boolean runScript() throws Exception {
                int fuel=0;
                int org=0;
                int equip=0;
                int holds = Swath.ship.holds();

                // Set product amounts
                switch (m_type.getCurrentChoice()) {
                        case Swath.FUEL_ORE:
                                fuel=holds;
                                break;
                        case Swath.ORGANICS:
                                org=holds;
                                break;
                        case Swath.EQUIPMENT:
                                equip=holds;
                                break;
                }

                // Loop         
                while (true) {
                        Land.exec(m_planet.getInteger());
                        TakeLeaveProducts.exec(fuel, org, equip);
                        LiftOff.exec();
                        Move.exec(m_sector2.getInteger());
                        Trade.exec(-fuel, -org, -equip);
                        Move.exec(m_sector.getInteger());
                }
        }
}
