import com.swath.*;
import com.swath.cmd.*;

/**
 * "Grab/Sell" script.
 *
 * @author Stein
 */
public class GrabSell extends UserDefinedScript {
	private Parameter m_planet;
	private Parameter m_type;

	public String getName() {
		return "Grab/Sell";
	}

	public boolean initScript() throws Exception {
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		m_planet = new Parameter("Grab from planet");
		m_planet.setType(Parameter.INTEGER);
		m_type = new Parameter("Type of product to grab and sell");
		m_type.setType(Parameter.CHOICE);
		m_type.addChoice(Swath.FUEL_ORE, "Fuel Ore");
		m_type.addChoice(Swath.ORGANICS, "Organics");
		m_type.addChoice(Swath.EQUIPMENT, "Equipment");
		m_type.setCurrentChoice(Swath.FUEL_ORE);

		registerParam(m_planet);
		registerParam(m_type);

		return true;
	}

	public boolean runScript() throws Exception {
		int fuel=0;
		int org=0;
		int equip=0;
		int holds = Swath.ship.holds();

		// Set product amounts
		switch (m_type.getCurrentChoice()) {
			case Swath.FUEL_ORE:
				fuel=holds;
				break;
			case Swath.ORGANICS:
				org=holds;
				break;
			case Swath.EQUIPMENT:
				equip=holds;
				break;
		}

		// Loop		
		while (true) {
			Land.exec(m_planet.getInteger());
			TakeLeaveProducts.exec(fuel, org, equip);
			LiftOff.exec();
			Trade.exec(-fuel, -org, -equip);
		}
	}
}
