import com.swath.*;
import com.swath.cmd.*;

/**
 *
 */
public class FillBubble extends UserDefinedScript {
	private Parameter mygate;

	public String getName() {
		// Return the name of the script
		return "FillBubble";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'sector' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().
		mygate = new Parameter("Bubble Gate");
		mygate.setType(Parameter.INTEGER);
		registerParam(mygate);

		// Some other initialisation could be done here
		// ...

		return true;
	}

	public boolean runScript() throws Exception {
		Bubble[] mybubble = Swath.getBubbles(Bubble.TYPE_NORMAL);

		for (int i=0; i<mybubble.length; i++) {
			int bubblegate[] = mybubble[i].gates();
			if (bubblegate[0] == mygate.getInteger()) {
				int[] bubblesectors = mybubble[i].sectors();
				Move.exec(bubblegate[0]);
				DropTakeFighters.exec(100, Swath.CORPORATE, Swath.DEFENSIVE_FTRS);
                for (int j=0; j < bubblesectors.length; j++) {
					Move.exec(bubblesectors[j]);
					DropTakeFighters.exec(1, Swath.CORPORATE, Swath.DEFENSIVE_FTRS);
				}
			}
		}

		return true;
	}

	public void endScript(boolean finished) {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}
