import com.swath.*;
import com.swath.cmd.*;

/**
 * This script demonstrates how to play sound files.
 *
 * @author Stein
 * @since SWATH 1.5
 */
public class ExampleScript6 extends UserDefinedScript {

	public String getName() {
		// Return the name of the script
		return "Example Script #6";
	}

	public String getDescription() {
		return "This script demonstrates how to play sound files.";
	}

	public boolean initScript() throws Exception {
		return true;
	}

	public boolean runScript() throws Exception {
		java.net.URL url;

		// Print BORG message
		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
		PrintText.exec("\n\nIncoming message:\n\n");
		SetTextMode.exec(SetTextMode.COLOR_MAGENTA, SetTextMode.COLOR_BLACK, SetTextMode.MODE_HIGHLIGHT);
		PrintText.exec("\"We are the BORG. Lower your shields and surrender your ships.\n");
		PrintText.exec(" We will add your biological and technological distinctiveness to our own.\n");
		PrintText.exec(" Your culture will adapt to service us. Resistance is futile!\"\n");
		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK, SetTextMode.MODE_NORMAL);
		PrintText.exec("\n-- The BORG\n\n");

		// Play BORG message :)
		url = getResource("Borg.wav");
		if (url != null) {
			playSoundURL(url);
		}
		else throw new Exception("Could not find the 'Borg.wav' file!");

		return true;
	}

	public void endScript(boolean finished) throws Exception {
	}
}
