import com.swath.*;
import com.swath.cmd.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This script shows how to create and display your own custom
 * parameter window. You can add any number of components in any way.
 * Read more about the Java Abstract Window Toolkit (AWT) for information
 * on how to use the different components available.
 *
 * @author Stein
 * @since SWATH 1.4
 */
public class ExampleScript5 extends UserDefinedScript {
	private Panel m_panel;
	private TextField m_name;
	private TextField m_fighters;
	private Button m_button;
	private int m_count;

	public String getName() {
		// Return the name of the script
		return "Example Script #5";
	}

	public String getDescription() {
		return "<html>This script shows how to create and "+
			   "display your own custom parameter window. "+
			   "You can add any number of components in any way. "+
			   "Read more about the Java Abstract Window Toolkit (AWT) "+
			   "for information on how to use the different "+
			   "components available.</html>";
	}

	public boolean initScript() throws Exception {
		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create a panel to add all components to
		m_panel = createPanel();

		// Create and add two text input fields to the panel
		m_panel.add(new Label("Name:"));
		m_name = new TextField(30);
		m_panel.add(m_name);
		m_panel.add(new Label("Fighters:"));
		m_fighters = new TextField(10);
		m_panel.add(m_fighters);

		// Create and add a button to the panel.
		// When the button is pressed the text "<<< Button pressed >>>" is printed.
		m_button = new Button("Press Me");
		m_button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				try {
					PrintText.exec("<<< Button pressed >>>\n");
					m_count++;
				}
				catch (Exception e) { }
			}
		});
		m_panel.add(m_button);
		m_count = 0;

		PrintText.exec("\n\n");

		return true;
	}

	public boolean runScript() throws Exception {
		String name;
		int fighters;

		// Shows the user defined parameter window with our new panel :)
		// If the user chooses to cancel the script, we exit.
		if (!showUserParamWindow(m_panel, 400, 300)) return true;

		// Get and parse the data from the input fields
		name = m_name.getText();
		try {
			fighters = Integer.parseInt(m_fighters.getText());
		}
		catch (NumberFormatException e) {
			fighters = 0;
		}

		// Do what you want...
		PrintText.exec("\n");
		PrintText.exec("Name....: " + name + "\n");
		PrintText.exec("Fighters: " + fighters + "\n");
		PrintText.exec("You pressed the button " + m_count + " times!\n");

		return true;
	}

	public void endScript(boolean finished) throws Exception {
	}
}
