import com.swath.*;
import com.swath.cmd.*;

/**
 * "The Sector Guard"<BR>
 * Shows how to wait for text and how to send your own
 * commando sequences to the TW server.
 * <BR><B>NOTE: This solution is only temporary.
 * In the future you will use Events to get input and
 * User Defined Commands when necessary.</B>
 *
 * @author Stein
 * @since SWATH 1.3
 */
public class ExampleScript4 extends UserDefinedScript {
	public String getName() {
		return "Example Script #4";
	}

	public String getDescription() {
		return "<html><b>The Sector Guard</b><br><br>"+
			   "Shows how to wait for text and how to send your "+
			   "own commando sequences to the TW server.<br><br>"+
			   "<i>NOTE: This solution is only temporary. "+
			   "In the future you will use Events to get input and "+
			   "User Defined Commands when necessary.</i></html>";
	}

	public boolean initScript() throws Exception {
		return true;
	}

	public boolean runScript() throws Exception {
		String str;

		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_RED,
						 SetTextMode.MODE_HIGHLIGHT);
		PrintText.exec("\n\n<<< Sector guard activated >>>\n\n");
		while (true) {
			// Wait for someone to warp in...
			str=WaitForText.exec("warps into");

			SetTextMode.exec(SetTextMode.COLOR_RED, SetTextMode.COLOR_BLACK,
							 SetTextMode.MODE_HIGHLIGHT);
			PrintText.exec("\n\n### Red alert: ");
			SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK,
							 SetTextMode.MODE_HIGHLIGHT);
			PrintText.exec(str+"\n\n");

			// Power up weapons systems!
			SendString.exec("AY");

			// Wait for trader to leave...
			str=WaitForText.exec("warps out");

			SetTextMode.exec(SetTextMode.COLOR_GREEN, SetTextMode.COLOR_BLACK,
							 SetTextMode.MODE_HIGHLIGHT);
			PrintText.exec("\n\n### Sector secured: ");
			SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK,
							 SetTextMode.MODE_HIGHLIGHT);
			PrintText.exec(str+"\n\n");

			// Lower weapons
			SendString.exec("0"+SendString.RETURN_KEY);
		}
	}

	public void endScript(boolean finished) throws Exception {
	}
}
