import com.swath.*;
import com.swath.cmd.*;

/**
 * This script demonstrate how to retrieve data from SWATH.
 * It also prints the data and asks the user some questions.
 * 
 * @author Stein
 * @since SWATH 1.3
 */
public class ExampleScript3 extends UserDefinedScript {
	private Parameter m_trader;
	private Parameter m_ship;
	private Parameter m_planet;

	public String getName() {
		return "Example Script #3";
	}

	public String getDescription() {
		return "This script demonstrates how to retrieve data from SWATH.\n"+
			   "It also prints the data and asks the user some questions.";
	}

	public boolean initScript() throws Exception {
		m_trader = new Parameter("A trader name");
		m_trader.setType(Parameter.STRING);
		m_ship = new Parameter("A ship #");
		m_ship.setType(Parameter.INTEGER);
		m_planet = new Parameter("A planet #");
		m_planet.setType(Parameter.INTEGER);

		registerParam(m_trader);
		registerParam(m_ship);
		registerParam(m_planet);

		return true;
	}

	public boolean runScript() throws Exception {
		Sector aSector;
		Trader aTrader;
		Ship aShip;
		Planet aPlanet;
		Corporation aCorp;
		String trader;
		int ship;
		int planet;
		int corp;
		int[] colos;
		int res;
		int i,n;

		// Set white foreground and black background + highlight mode
		SetTextMode.exec(SetTextMode.COLOR_WHITE, SetTextMode.COLOR_BLACK,
						 SetTextMode.MODE_HIGHLIGHT);
		PrintText.exec("\n\n");

		// Display some trader, ship and planet info
		trader=m_trader.getString();
		if (!trader.equals("")) {
			aTrader = Swath.getTrader(trader);
			if (aTrader != null) {
				PrintText.exec("Trader '"+trader+"' has "+
							   aTrader.credits()+" credits.\n");
			}
			else PrintText.exec("Trader '"+trader+"' is unknown.\n");
		}
		ship = m_ship.getInteger();
		if (ship != 0) {
			aShip = Swath.getShip(ship);
			PrintText.exec("Ship #"+ship+" has "+aShip.fighters()+" fighters.\n");
		}
		planet = m_planet.getInteger();
		if (planet != 0) {
			aPlanet = Swath.getPlanet(planet);
			colos = aPlanet.colonists();
			PrintText.exec("Planet #"+planet+" has "+colos[Swath.EQUIPMENT]+
						   " colonists at product type Equipment.\n");
		}

		// Set green foreground and black background + highlight mode
		SetTextMode.exec(SetTextMode.COLOR_GREEN, SetTextMode.COLOR_BLACK,
						 SetTextMode.MODE_HIGHLIGHT);
		PrintText.exec("\n");

		// Ask if the user wants to dump info
		res=MessageBox.exec("Dump info about you, your ship and SWATH ?",
							"SWATH Example Script #3",
							MessageBox.ICON_QUESTION, MessageBox.TYPE_YES_NO);
		if (res == MessageBox.RES_YES) {
			// Dump your trader info
			Swath.you.dump();
			// Dump your trader info
			corp = Swath.you.corp();
			if (corp > 0) {
				aCorp = Swath.getCorporation(corp);
				aCorp.dump();
			}
			// Dump the current ship info
			Swath.ship.dump();
			// Dump the main SWATH info
			Swath.main.dump();
		}

		// Set magenta foreground and black background + highlight mode
		SetTextMode.exec(SetTextMode.COLOR_MAGENTA, SetTextMode.COLOR_BLACK,
						 SetTextMode.MODE_HIGHLIGHT);

		// Ask if the user wants to dump sector info for sector #1
		res=MessageBox.exec("Dump sector #1 ?", "SWATH Example Script #3",
							MessageBox.ICON_QUESTION, MessageBox.TYPE_YES_NO);
		if (res == MessageBox.RES_YES) {
			// Get and dump sector info for sector #1
			aSector = Swath.getSector(1);
			aSector.dump();
		}

		return true;
	}

	public void endScript(boolean finished) throws Exception {
	}
}
