import com.swath.*;
import com.swath.cmd.*;

/**
 * This script trades a product between two ports.
 * It buys from the port in sector 1 and sells to
 * the port in sector 2.
 * 
 * @author Stein
 * @since SWATH 1.3
 */
public class ExampleScript2 extends UserDefinedScript {
	private Parameter m_sector1;
	private Parameter m_sector2;
	private Parameter m_type;
	private Parameter m_amount;
	private Parameter m_cycles;

	public String getName() {
		return "Example Script #2";
	}

	public String getDescription() {
		return "This script trades a product between two ports.\n"+
			   "It buys from the port in sector 1 and sells to\n"+
			   "the port in sector 2.";
	}

	public boolean initScript() throws Exception {
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		m_sector1 = new Parameter("Sector 1");
		m_sector1.setType(Parameter.INTEGER);
		m_sector1.setInteger(Swath.main.currSector());
		m_sector2 = new Parameter("Sector 2");
		m_sector2.setType(Parameter.INTEGER);
		m_type = new Parameter("Type of product");
		m_type.setType(Parameter.CHOICE);
		m_type.addChoice(Swath.FUEL_ORE, "Fuel Ore");
		m_type.addChoice(Swath.ORGANICS, "Organics");
		m_type.addChoice(Swath.EQUIPMENT, "Equipment");
		m_type.setCurrentChoice(Swath.FUEL_ORE);
		m_amount = new Parameter("Amount of product");
		m_amount.setType(Parameter.INTEGER);
		m_cycles = new Parameter("Number of cycles");
		m_cycles.setType(Parameter.INTEGER);
		m_cycles.setInteger(1);

		registerParam(m_sector1);
		registerParam(m_sector2);
		registerParam(m_type);
		registerParam(m_amount);
		registerParam(m_cycles);

		return true;
	}

	public boolean runScript() throws Exception {
		int fuel=0;
		int org=0;
		int equip=0;

		// Set product amounts
		switch (m_type.getCurrentChoice()) {
			case Swath.FUEL_ORE:
				fuel=m_amount.getInteger();
				break;
			case Swath.ORGANICS:
				org=m_amount.getInteger();
				break;
			case Swath.EQUIPMENT:
				equip=m_amount.getInteger();
				break;
		}
		// Trade
		for (int i=1; i<=m_cycles.getInteger(); i++) {
			Trade.exec(fuel, org, equip);
			Move.exec(m_sector2.getInteger());
			Trade.exec(-fuel, -org, -equip);
			Move.exec(m_sector1.getInteger());
		}
		// Done
		return true;
	}

	public void endScript(boolean finished) throws Exception {
	}
}
