import com.swath.*;
import com.swath.cmd.*;

/**
 * This is my first SWATH script. It moves your ship to
 * a sector and lands on a planet there.
 *
 * @author Stein
 * @since SWATH 1.3
 */
public class ExampleScript1 extends UserDefinedScript {
	private Parameter sector;
	private Parameter planet;

	public String getName() {
		// Return the name of the script
		return "Example Script #1";
	}

	public String getDescription() {
		// Return a description of the script.
		// It can be an URL to a HTML page or file,
		// or just normal HTML text or plain text.
		return "This is my first SWATH script.\n"+
			   "It moves your ship to a sector and lands on a planet there.";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'sector' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().
		sector = new Parameter("Move to sector");
		sector.setInteger(Swath.main.currSector());

		// Create the parameter 'planet' and set the type to INTEGER.
		// The default value will be set to 0 by setType().
		planet = new Parameter("Land on planet");
		planet.setType(Parameter.INTEGER);

		// Register the 2 parameters
		registerParam(sector);
		registerParam(planet);

		// Some other initialisation could be done here
		// ...

		return true;
	}

	public boolean runScript() throws Exception {
		// Execute Move command
		Move.exec(sector.getInteger());
		// Execute Land command
		Land.exec(planet.getInteger());
		// End of script
		return true;
	}

	public void endScript(boolean finished) throws Exception {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}
