import com.swath.*;
import com.swath.cmd.*;

/**
 * This is a simple etherprobe explore script.
 * It ask you for start sector and number of cycles.
 * Specify 0 as cycles for it to run until it reaches
 * the last sector in the universe.
 * The script will refill your etherprobes if your at SD
 * until your out of cash or reach cycle limit.
 * The script shoots out an eprobe to a sector then
 * it will void that sector and shoot out another to one
 * sector number higher then the first one until we either
 * reaches last sector in the universe or run out of money
 * whatever comes first.
 *
 * rev 1.2
 * 
 * @author Macahan
 */
public class EprobeExplore extends UserDefinedScript {
	private Parameter startSector;
	private Parameter cycles;
	private Parameter toggleVoid;
	private Parameter sixWarps;
	private Parameter fiveWarps;
	private Parameter fourWarps;
	private Parameter threeWarps;
	private Parameter twoWarps;
	private Parameter oneWarps;
	public String getName() {
		// Return the name of the script
		return "EtherProbe Explore";
	}

	public boolean initScript() throws Exception {
		// Initialisation of the script is done in this method.
		// All parameters should be created and registered here.
		// If something goes wrong, return false.

		// Check that we are at the correct prompt
		if (!atPrompt(Swath.COMMAND_PROMPT)) return false;

		// Create the parameter 'startSector' and set the value to
		// the current sector.
		// The type will be set to INTEGER by setInteger().

		startSector = new Parameter ("What sector do you want to start at?");
		startSector.setInteger(Swath.main.currSector());

		// Create the parameter 'cycles' and set the value to
		// to zero.
		// The type will be set to INTEGER by setInteger().
		cycles = new Parameter ("How many cycles (0 = until done)");
		cycles.setInteger(0);

		// If we want to set voids during ether probe or not.
		// setting voids will result in longer warp paths.
		// but you will also possible lock out certain parts of
		// the universe so voids is good on a first run.
		// then do a second run without setting any voids.
		// to get the rest of the universe.
		toggleVoid = new Parameter ("Set voids ?");
		toggleVoid.setType(Parameter.BOOLEAN);
		toggleVoid.setBoolean(true);

		oneWarps = new Parameter ("One Warps ?");
		oneWarps.setType(Parameter.BOOLEAN);
		oneWarps.setBoolean(true);

		twoWarps = new Parameter ("Two Warps ?");
		twoWarps.setType(Parameter.BOOLEAN);
		twoWarps.setBoolean(true);

		threeWarps = new Parameter ("Three Warps ?");
		threeWarps.setType(Parameter.BOOLEAN);
		threeWarps.setBoolean(false);

		fourWarps = new Parameter ("Four Warps ?");
		fourWarps.setType(Parameter.BOOLEAN);
		fourWarps.setBoolean(false);

		fiveWarps = new Parameter ("Five Warps ?");
		fiveWarps.setType(Parameter.BOOLEAN);
		fiveWarps.setBoolean(false);

		sixWarps = new Parameter ("Six Warps ?");
		sixWarps.setType(Parameter.BOOLEAN);
		sixWarps.setBoolean(true);

		// Resgister the parameters the the user picked
		// so we can use them from inside the script.
		registerParam(startSector);
		registerParam(cycles);
		registerParam(toggleVoid);
		registerParam(oneWarps);
		registerParam(twoWarps);
		registerParam(threeWarps);
		registerParam(fourWarps);
		registerParam(fiveWarps);
		registerParam(sixWarps);

		// Some other initialisation could be done here
		// ...

		return true;
	}

	public boolean runScript() throws Exception {
		// declare the params we need
		Sector sector;
 		int loop, start, totsectors, maxcycles, cycle;
 		boolean activateVoids, oneWarp, twoWarp, threeWarp, fourWarp, fiveWarp, sixWarp;
		// load the start sector we picked
		start = startSector.getInteger();
		activateVoids = toggleVoid.getBoolean();
		oneWarp = oneWarps.getBoolean();
		twoWarp = twoWarps.getBoolean();
		threeWarp = threeWarps.getBoolean();
		fourWarp = fourWarps.getBoolean();
		fiveWarp = fiveWarps.getBoolean();
		sixWarp = sixWarps.getBoolean();

		// Since you can't launch an eprobe in your current sector let's adjust
		// sector # to a higher value..
		if (start == Swath.main.currSector()) start++;
		// load max cycles
		maxcycles = cycles.getInteger();
		// if user set 0 as maxcycles then set maxcycles so we
		// will run until we reaches last sector of universe.
		if (maxcycles == 0) maxcycles = Swath.main.sectors();
		// Let's set 1 for our first cycle
		cycle = 1;
		// set max size of universe.
		totsectors = Swath.main.sectors();
		// set param loop
		loop=0;
		// start our main loop
		while( loop < 1 ) {
			// we got any etherprobes ???
			if (Swath.ship.etherProbes()==0) {
				// if we are here we didn't have any. Let's check
				// if we are at SD so we can buy some..
				if (Swath.main.currSector() == Swath.main.stardock()) {
					// apparently we are at SD so let's check
					// our cash status if we can buy at least 1 eprobe
					if ( Swath.you.credits() >= 3000) {
						// dock at SD got to Hardware and buy eprobes.
						SendString.exec("ps");
						WaitForText.exec("<StarDock> Where to? (?=Help)");
						SendString.exec("he");
						// here we will have future check for how many
						// probes the ship will take
						String x;
						x = WaitForText.exec("How many Probes do you want (Max");
						// we got enough credit for max load ?
						if ((Swath.you.credits()/3000) < 20 ) {
							// nope we can't aford max load
							int num;
							// let's buy what we can afford.
							num = Swath.you.credits()/3000;
							SendString.exec(+num+"\rqqi");
							WaitForText.exec("Command [TL=00:00:00]:[");
						}
						// can we buy more then max load
						if ( (Swath.you.credits()/3000) > 20 ) {
							// yes get max load
							SendString.exec("20\rqqi");
							WaitForText.exec("Command [TL=00:00:00]:[");
						}
					}
					// if above check failed let's quit if we
					// don't have enough cash to buy more probes.
					else {
						PrintText.exec("\nOut of cash quitting!\n");
						if (activateVoids==true){
							// remove all our voids we set probing.
							SendString.exec("cv0\ryyq");
						}
						// quit cleanly
						return true;
					}
				}
				// ok if we where not at SD let's quit
				else {
					// since we where out of probes and not at SD time to quit
					PrintText.exec("\n No more eprobes and not at SD so I can not buy more probes\n");
					if (activateVoids==true) {
						// remove all our voids we set probing.
						SendString.exec("cv0\ryyq");
					}
					// quit cleanly
					return true;
				}
			}

			sector = Swath.getSector(start);
			if (sector.isUnexplored()) {
				// only probe sectors that got 1 warps (dead ends)
				switch (sector.warps()){
				 case  6:
				 	if (sixWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true){
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 case  5:
				 	if (fiveWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true){
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 case  4:
					if (fourWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true){
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 case 3:
					if (threeWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true){
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 case 2:
				 	if (twoWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true){
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 case 1:
				 	if (oneWarp==true) {
						LaunchEtherProbe.exec(start);
						// set that sector void.
						if (activateVoids==true) {
							SendString.exec("cv"+start+"\rq");
							// take a break let us get to command prompt again
							WaitForText.exec("Command [TL=");
						}
					}
				 	break;
				 default:
				 	break;
				}
				/*
				if (sector.warps()<= 2) {
					// launch our therprobe
					LaunchEtherProbe.exec(start);
					// set that sector void.
					if (activateVoids==true) {
						SendString.exec("cv"+start+"\rq");
						// take a break let us get to command prompt again
						WaitForText.exec("Command [TL=");
					}
				}
				// ok if we have a sector with 5 or 6 warps unexplored
				// probe it and void it.
				if (activateVoids==true) {
					if (sector.warps()>=5) {
						LaunchEtherProbe.exec(start);
						SendString.exec("cv"+start+"\rq");
						WaitForText.exec("Command [TL=");
					}
				}
				*/
			}
			// for explored sectors
			else {
				// if the sector is a 6 warp void it.. so our probes will
				// get better paths.
				if (activateVoids==true) {
					if (sector.warps()>5) {
						SendString.exec("cv"+start+"\rq");
						WaitForText.exec("Command [TL=");
					}
				}
			}

			// add the sector counter for next sector to probe
			start++;
			// check if next sector is same as current in that case
			// we increase the value.
			if (start == Swath.main.currSector()) start++;
			// have we reached the highest sector number of the
			// universe yet ??
			if (start > totsectors) {
				// yes so let's clean the voids we have set.
				SendString.exec("cv0\ryyq");
				PrintText.exec("\nMax sectors reached quitting!\n");
				// quit cleanly
				return true;
			}
			// have we reached the max specified cycles yet ??
			if ( maxcycles <= cycle ) {
				// yes so let's clean the voids we have set.
				SendString.exec("cv0\ryyq");
				PrintText.exec("\nMax cycles reached quitting!\n");
				// quit cleanly
				return true;
			}
			// increase the cycle counter..
			cycle++;
			// end of while loop
		}

		// we shouldn't reach this part but just incase
		// let's put in a quit signal
		return true;
	}

	public void endScript(boolean finished) {
		// Do some clean up here if necessary.
		// Remember: In Java you don't need to free any memory
		// since all memory is garbage collected when not used.
	}
}

