Program CompLd;
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}
uses
  Crt,FParser;
label
  MergeExit;
type
  MyArray = ARRAY[1 .. 5000,1 .. 6] of integer;
var
  A,B : ^MyArray;
  index : integer;
  sector : integer;
  tosector : integer;
  i,j,k,io,ec1 : integer;
  toks : integer;
  tokstr,ptok : string;
  P : ParseType;
  MyName,MyFile,S,SCim,SLd,Answer : string;
  Done,GoodWarp : boolean;
  F : text;
  TotWarps,TotSectors : longint;
  USize : integer;
  BadWarps : longint;

FUNCTION isdigit( var c : char) : boolean;
{ If the character is a digit, returns TRUE, otherwise returns FALSE }
BEGIN
  If ((c >= '0') and (c <= '9')) THEN
    isdigit := TRUE
  ELSE isdigit := FALSE;
END;


BEGIN
  new(A);
  new(B);
  Usize := 1000;
  {
   check to see if universe if larger than 1000 sectors;
   (e.g. COMPLD 2500) if so alter the Usize parameter
  }
  If ParamCount > 0 then begin
    Val(ParamStr(1),Usize,ec1);
    if ec1 <> 0 then
      Usize := 1000;
  end;
  tokstr := ' '+#8+#9+#10+#13;
  for i := 1 to USize do
    for j := 1 to 6 do begin
      B^[i][j] := 0;
      A^[i][j] := 0;
    end;
  TextColor(LightCyan);
  TextBackground(Blue);
  ClrScr;
  Gotoxy(25,1);Write(' COMPARE LEVEL DIAGRAMS v1.02 ');
  GotoXy(25,2);Write(' COPYRIGHT (C) 1993 David Myers');
  GotoXy(25,3);Write(' All Rights reserved. (07/02/93)');
  GotoXY(1,5);Write(' Enter Level Diagram to be compared:                 ');
  GotoXY(1,7);
  Write('                                           ');
  GotoXY(1,7);
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        GotoXY(1,5); Write(' Invalid Filename.  New Name for Text File?');
        GotoXY(1,7); BuildString(S);
        If S = '' then
          Goto MergeExit;
      end
    UNTIL (io = 0);
    SLd := S;
  end;
  If S = '' then
    goto MergeExit;
  While (NOT Eof(F)) do begin
    ReadLn(F,S);
    toks := Parse_Str(tokstr,S,P);
    if (toks > 1) then begin
      if Isdigit(P.s[0][1]) then begin
        Val(P.s[0],sector,ec1);
        if (ec1 = 0) then begin
          for j := 1 to toks-1 do begin
            Val(P.s[j],tosector,ec1);
            if (ec1 = 0) then begin
              k := 1;
              Done := FALSE;
              While ((k < 7) and NOT Done) do begin
                if (A^[Sector][k] = 0) then
                  Done := TRUE
                else if (A^[Sector][k] = toSector) then begin
                  Done := TRUE;
                  k := 7;
                end
                else begin
                  Inc(k);
                  if (k > 6) then
                    Done := TRUE;
                end;
              end;
              if (k < 7) then
                A^[Sector][k] := tosector;
            end;
          end;
        end;
      end;
    end;
  end;

  GotoXY(1,5);Write(' Enter CIM .SCT plot to be compared:                 ');
  GotoXY(1,7);
  Write('                                           ');
  GotoXY(1,7);
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        GotoXY(1,5); Write(' Invalid Filename.  New Name for Text File?');
        GotoXY(1,7); BuildString(S);
        If S = '' then
          Goto MergeExit;
      end
    UNTIL (io = 0);
    SCim := S;
  end;
  If S = '' then
    goto MergeExit;
  { read in the CIM file }
  While (NOT Eof(F)) do begin
    ReadLn(F,S);
    toks := Parse_Str(tokstr,S,P);
    if (toks > 1) then begin
      if Isdigit(P.s[0][1]) then begin
        Val(P.s[0],sector,ec1);
        if (ec1 = 0) then begin
          for j := 1 to toks-1 do begin
            Val(P.s[j],tosector,ec1);
            if (ec1 = 0) then begin
              k := 1;
              Done := FALSE;
              While ((k < 7) and NOT Done) do begin
                if (B^[Sector][k] = 0) then
                  Done := TRUE
                else if (B^[Sector][k] = toSector) then begin
                  Done := TRUE;
                  k := 7;
                end
                else begin
                  Inc(k);
                  if (k > 6) then
                    Done := TRUE;
                end;
              end;
              if (k < 7) then
                B^[Sector][k] := tosector;
            end;
          end;
        end;
      end;
    end;
  end;
  GotoXY(1,10);
  ptok := ' .'+#8+#9+#10+#13;
  WriteLn;
  Write(' Output File Name : ');
  BuildString(MyName);
  toks := Parse_Str(ptok,MyName,P);
  if (toks > 0) then
    MyName := P.s[0]
  ELSE MyName := 'COMPARE';
  MyFile := MyName + '.CMP';
  Assign(F,MyFile);
  Rewrite(F);
  TotWarps := 0;
  TotSectors := 0;
  BadWarps := 0;

  { check for missing warps in the LD representation }

  for i := 1 to USize do begin
    if B^[i][1] <> 0 then begin
      Inc(TotSectors);
      for j := 1 to 6 do begin
        if (B^[i][j] <> 0) then
          Inc(Totwarps);
        GoodWarp := FALSE;
        for k := 1 to 6 do begin
          if B^[i][j] = A^[i][k] then
            GoodWarp := TRUE;
        end;
        if NOT GoodWarp then begin
          Inc(BadWarps);
          If (B^[i][j] = 0) then begin
            WriteLn(' LD has an extra warp at sector ',i);
            WriteLn(F,' LD has an extra warp at sector ',i);
          end
          else begin
            WriteLn('  LD is missing a warp from ',i,' to ',B^[i][j]);
            WriteLn(F,'  LD is missing a warp from ',i,' to ',B^[i][j]);
          end;
        end;
      end;

      { Now check for extra warps in the LD representation }
      { these will be due to parsing errors and give us a  }
      { feel for how well the code functions               }

      for j := 1 to 6 do begin
        GoodWarp := FALSE;
        for k := 1 to 6 do begin
          if A^[i][j] = B^[i][k] then
            GoodWarp := TRUE;
        end;
        if NOT GoodWarp then begin
          If (A^[i][j] = 0) then begin
            {
            Since we probably already saw, these, we ignore them.
            WriteLn('  LD is missing a warp from ',i,' to ',B^[i][k]);
            WriteLn(F,'  LD is missing a warp from ',i,' to ',B^[i][k]);
            }
          end
          else begin
            Inc(BadWarps);
            WriteLn(' LD has an extra warp at sector ',i);
            WriteLn(F,' LD has an extra warp at sector ',i);
          end;
        end;
      end;

    end;
  end;
  ClrScr;
  WriteLn;
  WriteLn('-------------------------------------------------------');
  WriteLn;
  WriteLn(' When ',SLd,' is compared to the CIM File ',SCim);
  WriteLn(' There are ',TotWarps,' Total Warps in the CIM File');
  WriteLn(' And ',BadWarps,' Total missing and/or extra warps.');
  WriteLn(' With ',TotSectors,' sectors out of ',USize,' compared, then the ');
  WriteLn(' Efficiency of ',SLd,' is: ',(TotWarps - BadWarps)*100/TotWarps:7:2);
  WriteLn(F);
  WriteLn(F,'-------------------------------------------------------');
  WriteLn(F);
  WriteLn(F,' When ',SLd,' is compared to the CIM File ',SCim);
  WriteLn(F,' There are ',TotWarps,' Total Warps in the CIM File');
  WriteLn(F,' And ',BadWarps,' Total missing and/or extra warps.');
  WriteLn(F,' With ',TotSectors,' sectors out of ',USize,' compared, then the ');
  WriteLn(F,' Efficiency of ',SLd,' is: ',(TotWarps - BadWarps)*100/TotWarps:7:2);
  Close(F);
  WriteLn;
  Writeln('Done!');
  TextColor(WHite);
  TextBackground(Black);
  Delay(5000);
  ClrScr;
MergeExit:
  dispose(A);
  dispose(B);
END.
