'
'  SHIPLIB.BAS Anticopyright (A) 1993 Brandon Bannerman
'  No rights reserved, except the right to messily and violently abuse with
'  a rusty cheese grater anyone who tries to rip me off. <Grin>
'  Patent Bending. Yes, I'm him, I'm the programmer from the arctic north!
'  Rrrroooar... I tear the patent up! Rrrriiip!
'  <Never mind, inside joke>
'This is the source code to the SHIPLIB library. It contains a few useful
'functions and subroutines, some designed specifically for use with TW2002.
'This is not my entire library of TW2002 functions, simply the only ones I
'needed for SHIPEDIT and KITWORKS.
'I am officially releasing this source code to the Public Domain. Feel free
'to make as many copies as you want, and include this library into your own
'programs. I hereby grant permission to modify this source code for your own
'use, and include such modified code into your own programs, so long as you
'give credit where credit is due. I do ask that you not distribute modified
'copies of this code, except as part of your own programs, and that when you
'give copies of this to others that you give them unmodified copies.
'  Now that the legal drek is over with...
'
DECLARE FUNCTION Forat% (ScreenLine%, ScreenColumn%)
  'Gets the foreground color at the screen coordinates specified by
  'ScreenLine% and ScreenColumn%.
DECLARE FUNCTION Bakat% (ScreenLine%, ScreenColumn%)
  'Gets the foreground color at the screen coordinates specified by
  'ScreenLine% and ScreenColumn%.
DECLARE FUNCTION Cat% (ScreenLine%, ScreenColumn%)
  'Gets the character present at ScreenLine%, ScreenColumn%.
DECLARE FUNCTION Sat$ (ScreenLine%, ScreenColumn%)
  'Gets the full attribute present at ScreenLine%, ScreenColumn%. This is
  'a Char integer from 0 to 255. See the routines Forat% and Bakat% for
  'info on how to derive the foreground and background color from this.
DECLARE FUNCTION TWTtoBST$ (TWText$)
DECLARE FUNCTION BSTtoTWT$ (BST$, LenTWT%)
  'Routines to convert a QB string to a Pascal string, and vice versa.
  'TWTtoBST converts Pascal strings (referred to here as TradeWarsText) to
  'BasicSTrings, and BSTtoTWT back. BSTtoTWT requires a second parameter,
  'which tells it the maximum length of the Pascal string (so it can fill any
  'unused space with ASCII 0).
DECLARE SUB Pstra (StringVal$)
  'An *extremely* handy routine I designed, which takes a string parameter,
  'parses all the TW2002 color codes in it, and prints the result, changing
  'colors along the way as necessary. See the actual routine for more info.
  'Also see this routine for information on how to use Forat% and Bakat% to
  'do useful things like turn blinking on and off, and inverse the current
  'foreground and background.
DECLARE FUNCTION GetKey$ (ValidChars$)
  'A single-character filtered input routine. See routine for more info.
DECLARE FUNCTION GetLin$ (MaxLen%, Valids$)
  'A filtered line input routine which uses GetKey. Note: changes the
  'foreground to yellow and the background to blue, creating a "field" which
  'shows the user how much space they have to type in, then changes the color
  'back to grey. If you wish to preserve your colors, or use your own, modify
  'the appropriate code. See routine for more info.
DECLARE FUNCTION DBLtoP6R$ (DBL#)
DECLARE FUNCTION P6RtoDBL# (P6R$)
  'Functions designed by Jason Boyd to convert between a QB double-precision
  'variable, and the hideously annoying Pascal "real" variables. Many thanx
  'to the Boyd individual for letting me download these routines from him
  'last year in exchange for the offsets of the Ship#9 alignment.

'
'Tell the user-defined TYPE ShipStat what to do with itself...
'

TYPE ShipStat
  HoldCost AS INTEGER
    'Holds portion of the ship's cost
  DrivCost AS INTEGER
    'Drive portion of the ship's cost
  CompCost AS INTEGER
    'Computer portion of the ship's cost
  HullCost AS INTEGER
    'Hull portion of the ship's cost
  MaxHolds AS INTEGER
    'Maximum Holds this shiptype can carry
  InitHolds AS INTEGER
    'Holds this shiptype starts with
  MoveRate AS STRING * 6
    'Pascal 6-byte real (Thnx to the Boydmeister), the percentage of the base
    'moves in Editor Option <G> this ship gets per day. The actual number of
    'turns in a 100-turn/day game.
  MaxFtr AS INTEGER
    'Maximum fighter load of this shiptype
  MaxShi AS INTEGER
    'Maximum shields this ship can be fitted with
  OffOdds AS INTEGER
    'Offensive odds * 10 (ie, 1.4:1 is stored as 14)
  MaxMines AS INTEGER
    'Maximum Mines this ship can carry
  MaxBeac AS INTEGER
    'Maximum beacons this ship can carry
  MaxGen AS INTEGER
    'Maximum Genesis torps this ship can carry
  LRS AS STRING * 1
    'If this ship can carry a long range scanner, this is equal to ASCII
    'character 1, otherwise it is 0. Setting it to 1 does little good on
    'ship #2 unless you've messed with it in AEdit.
  TWD AS STRING * 1
    'If this ship can carry a transwarp drive, this is equal to ASCII
    'character 1, otherwise it is 0.
  PLS AS STRING * 1
    'If this ship can carry a planet scanner, this is equal to ASCII
    'character 1, otherwise it is 0.
  Crap3 AS LONG
    'I have no clue. I dimensioned this as a LONG INT (which occipies 4 bytes)
    'instead of a STRING*4 to save string space in the compiler.
  MaxPHM AS INTEGER
    'Maximum photon missiles this ship can carry.
  MaxFtrAtt AS INTEGER
    'Maximum fighters this ship can use in one attack. Setting this above 9999
    'is extraneous in v1.03, since players can only use 4 characters of input
    'for this value.
  Crap4 AS LONG
    'Ditto Crap3.
END TYPE

'
'Dimension Variables...
'
DIM SHARED ShipType AS ShipStat
  'So that we can actually *use* the type of ShipStat.
DIM SHARED True AS INTEGER
DIM SHARED False AS INTEGER
  'Boolean variables. QB treats a value of 0 as False and a nonzero value as
  'True for logical operations.
DIM SHARED Upper AS STRING * 26
DIM SHARED Lower AS STRING * 26
DIM SHARED Alpha AS STRING * 52
DIM SHARED Numeric AS STRING * 10
DIM SHARED DOS AS STRING * 78
DIM SHARED Hexadecimal AS STRING * 22
  'Filters for the GetKey and GetLin subroutines, both of my design.
'
True = -1
False = 0
  'Define True and False. (Duh)
Upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
Lower = "abcdefghijklmnopqrstuvwxyz"
Alpha = Upper + Lower
Numeric = "0123456789"
DOS = Alpha + Numeric + "!@#$^&()_-{}.~`'"
Hexadecimal = Numeric + "ABCDEFabcdef"
  'Define the filters. For both GetKey and GetLin, you can combine strings or
  'even create your own filters--so long as you pass a string variable or a
  'null "" string, neither of them care.
'

DEFINT A-Z
FUNCTION Bakat (ScreenLine, ScreenColumn)
  'Bakat returns the foreground color at ScreenLine, ScreenColumn, in the
  'format used by the COLOR statement, using Cat to get the attribute.
  IF ScreenLine = 0 THEN ScreenLine = CSRLIN
  IF ScreenColumn = 0 THEN ScreenColumn = POS(0)
  'If Either ScreenLine or ScreenColumn is equal to 0, Bakat defaults them
  'to the current positions.
  Attribute = Cat(ScreenLine, ScreenColumn)
  IF Attribute < 128 THEN
    Bakat = INT(Attribute / 16)
    'Attributes 0 to 127 are the normal range of colors...
  ELSE
    Attribute = Attribute - 128
    Bakat = INT(Attribute / 16)
    '...while attributes 128 to 255 are exactly the same, with the exception
    'that they are blinking. Bakat doesn't use these, but it needs to know
    'this so that it can subtract 128 from the Attribute in order to work
    'normally.
  END IF
END FUNCTION

DEFSNG A-Z
FUNCTION BSTtoTWT$ (BST$, LenTWT%)
  'Function to convert QB strings to Pascal strings.
LenBST% = LEN(BST$)
  'Fairly self-explanatory.
IF LenBST% <> LenTWT% THEN BST$ = BST$ + STRING$(LenTWT% - LenBST%, 0)
  'If the length of the QB string is not the maximum specified for the Pascal
  'string, then it fills the excess space with zeros.
BSTtoTWT$ = CHR$(LenBST%) + BST$
  'Create the Pascal prefix byte (which tells Pascal how long this string is
  'supposed to be), and add the rest of the string to it. Tell the function
  'what it's supposed to tell the rest of the program.
END FUNCTION

DEFINT A-Z
FUNCTION Cat (ScreenLine, ScreenColumn)
  'Gets the color attribute preset at ScreenLine, ScreenColumn. Note that
  'there are two ways of doing this. If you have just executed a LOCATE
  'statement, use CSRLIN and POS(0) for the current locations, respectively.
  'If you have just executed a statement which prints anything, however, the
  'current screen location will be one column to the right of the last
  'character printed, so to get the color from that character, use
  'POS(0) - 1 for ScreenColumn.
  DEF SEG = &HB800
  Offset = (((ScreenLine - 1) * 80) + ScreenColumn) * 2 - 1
  Cat = PEEK(Offset)
END FUNCTION

DEFSNG A-Z
FUNCTION DBLtoP6R$ (DBL#)
  'If you really want documentation on these routines, ask Jason Boyd, author
  'of the AEdit/AExtern program. He wrote 'em, and I am only now gaining a
  'vague clue as to how they work, eh?
r$ = STRING$(6, 0)
IF DBL# = 0 GOTO zero
Ex% = INT(LOG(ABS(DBL#)) / LOG(2#)) + 129
MID$(r$, 1, 1) = CHR$(Ex%)
Man# = (DBL# / 2 ^ (Ex% - 129) - 1) * 128
M% = INT(Man#)
IF M% < 0 THEN M% = 128 - M%
MID$(r$, 6, 1) = CHR$(M%)
FOR T% = 5 TO 2 STEP -1
    Man# = (Man# - M%) * 256
    M% = INT(Man#)
    MID$(r$, T%, 1) = CHR$(M%)
    NEXT T%
zero:
DBLtoP6R$ = r$
END FUNCTION

DEFINT A-Z
FUNCTION Forat (ScreenLine, ScreenColumn)
  'Forat returns the foreground color at ScreenLine, ScreenColumn, in the
  'format used by the COLOR statement, using Cat to get the attribute.
  IF ScreenLine = 0 THEN ScreenLine = CSRLIN
  IF ScreenColumn = 0 THEN ScreenColumn = POS(0)
  'If Either ScreenLine or ScreenColumn is equal to 0, Forat defaults them
  'to the current positions.
  Attribute = Cat(ScreenLine, ScreenColumn)
  IF Attribute < 128 THEN
    Forat = Attribute MOD 16
    'Attributes 0 to 127 are the normal range of colors...
  ELSE
    Attribute = Attribute - 128
    Forat = (Attribute MOD 16) + 16
    '...while attributes 128 to 255 are exactly the same, with the exception
    'that they are blinking.
  END IF
END FUNCTION

DEFSNG A-Z
FUNCTION GetKey$ (ValidChars$)
  'This routine is one of my gems. It's a fairly simple filtered input
  'routine, with a few fancy twists and pretty compact code. The parameter
  'ValidChars$ is an optional filter for the input--if you set this to a
  'null "" string, GetKey will accept *any* input. The parameter *must* be
  'included, though--QB's rule, not mine--it just doesn't need to equal
  'anything. (Although to be quite honest, issuing GetKey with a null
  'parameter is functionally the exact same as issuing the below INPUT$(1)
  'function.) Note that GetKey will neither echo its received input to the
  'screen, nor print a carriage return when it is done--if you want to do
  'either of these things, you must do them yourself. (I did this because
  'there are many times when you will not want to do either--you will find
  'examples in KitWorks)
DO
  'Begin the loop, which continues until GetKey gets valid input.
  C$ = INPUT$(1)
    'Get a character from the keyboard.
  IF C$ <> "" THEN
    'If you test the INSTR function with C$ as a null string, it will *always*
    'return a true value, so this skips null strings.
    IF ValidChars$ = "" OR INSTR(ValidChars$, C$) THEN
      'If there is no filter, or if the pressed key is acceptable, it sets
      'GetKey to equal that input and exits the DO..LOOP...
      GetKey$ = C$
      EXIT DO
    ELSE
      '...otherwise, it gives a brief and mildly annoying beep (not quite as
      'bad as DOS's), and repeats the DO..LOOP.
      FOR x = 1 TO 2: SOUND 14000, 1: SOUND 2000, 1: NEXT x
    END IF
  END IF
LOOP
END FUNCTION

DEFINT A-Z
FUNCTION GetLin$ (MaxLen%, Valids$)
  'The GetLin function uses GetKey to provide a more flexible, expanded
  'version of QB's LINE INPUT statement. It cannot gather input from a
  'file number like LINE INPUT (LINE INPUT does fine for that), but it
  'accepts filters just like GetKey (in fact, it uses GetKey for all of
  'its input). GetLin will *not* provide its own prompt, with the exception
  'of the input field.
  'See GetKey for more info.

IF Valids$ <> "" THEN Valids$ = Valids$ + CHR$(13) + CHR$(8) + CHR$(27) + CHR$(24)
  'If the filter is not a null string, then GetLin adds the carriage return,
  'backspace, escape, and Ctrl-X keys to it so that it will accept them, too.
Accum$ = ""
  'Set the accumulated input to nothing. (Redundant, since the variable is
  'reset every time GetLin in called--but I put it in here on General
  'Principles.)

DIM Posit AS INTEGER
DIM ErrCode AS INTEGER
  'Dimension the variables which store the current number of characters GetLin
  'has received, and the error code returned.

ErrCode = 0
  'Set the errorcode to nothing. (Again, redundant, but done on GP)
Posit = 1
  'Set the current character to the first one.
PRINT ;
  'Done so that the XY positioning will work. This doesn't show *anything* on
  'the output screen--it is a null statement--but it apparently tells QB that
  'it's OK to store the XY position. (In case you're wondering, I have
  'no fragging clue exactly *why* this is so--I just "figured it out" one day)
XPos = CSRLIN
YPos = POS(1)
  'Store the current cursor position for later restoration.

COLOR 14, 1
  'Foreground: Yellow on Blue.
PRINT STRING$(MaxLen%, 32);
LOCATE XPos, YPos
  'Create the input field by printing a number of spaces equal to the maximum
  'characters GetLin will accept, and then restoring the original cursor
  'position.

DO
  'Begin an infinite loop. (Trust me on this one. There *are* ways to get out
  'of these things.
  A$ = GetKey$(Valids$)
    'Get a character using GetKey.
  SELECT CASE A$
    CASE IS <> ""
      'If the input wasn't a null string, then...
      SELECT CASE A$
        CASE CHR$(13)
          '...if the user pressed Enter, then exit the otherwise infinite
          'loop...
          EXIT DO
          '...hahaha... I am so sly.
        CASE CHR$(8)
          'But if they pressed backspace, then...
          IF Posit > 1 THEN
            '...if the cursor isn't at the first input position, then...
            NowPos = POS(0) - 1
            LOCATE CSRLIN, NowPos
            '...save the current position and back up one space...
            PRINT " ";
            '...print a space...
            LOCATE CSRLIN, NowPos
            '...and back up once again.
            Posit = Posit - 1
            Accum$ = LEFT$(Accum$, LEN(Accum$) - 1)
            'Then, reduce the current input position by one, and cut the
            'rightmost character off of the accumulated input (Accum$).
            '  All that to delete a bloody character!
          END IF
        CASE CHR$(24)
          'The Ctrl-X key, which clears the line (as well as the accumulated
          'input), and returns the cursor to the original position.
          NowPos = POS(0) - Posit + 1
          LOCATE CSRLIN, NowPos
          PRINT STRING$(MaxLen%, 32);
          LOCATE CSRLIN, NowPos
          Posit = 1
          Accum$ = ""
          'Basically, this does the same thing as the backspace, except it
          'kills everything the user has typed in so far. There is no test to
          'see if they haven't typed anything yet; it won't hurt anything.
          'This is handy if a user has really FUBARed their input, and they
          'have a slow typematic rate in which case they don't want to spend
          'ten seconds waiting for the whole thing to get deleted. (Of course,
          'my typematic rate is 32, so I never use this :)
        CASE CHR$(27)
          'The escape key. You may or may not want to disable this for some
          'routines--at least test for it; an aborted input usually means the
          'user did *not* want the routine to accept what they'd typed. This
          'will return a null string to the program, so you may want to enable
          'the error code variable as SHARED if you want a null string to be
          'valid input.
          NowPos = POS(0) - Posit + 1
          LOCATE CSRLIN, NowPos
          Pstra ("~BAborted" + STRING$(MaxLen%, 32) + "~!")
            'Uses Pstra (qv) to change the color to red (~B) and tell the user
            'that they have, in fact, aborted the input. You might want to
            'disable the Aborted string if you have something else in mind.
          Accum$ = ""
          EXIT DO
        CASE ELSE
          IF Posit <> MaxLen% + 1 THEN
            'If the character has not exceeded the maximum characters
            'possible, then...
            COLOR 14
            PRINT A$;
            Posit = Posit + 1
            Accum$ = Accum$ + A$
              '...print it and add it to the accumulated input. Otherwise...
          ELSE
            FOR x = 1 TO 2: SOUND 14000, 1: SOUND 2000, 1: NEXT x
              '...annoy the living shit out of the end user. <Grin>
          END IF
      END SELECT
  END SELECT
LOOP
  'Once GetLin has completed its input (by Enter or Esc), then...
GetLin$ = Accum$
COLOR 7, 0
  'Set GetLin to equal what it has received so far, and change the color to
  'grey on black. (I chose this fairly neutral color mainly because I have no
  'clue how to detect the current screen color in text mode yet. If someone
  'knows how to in QB, do tell.
END FUNCTION

DEFSNG A-Z
FUNCTION P6RtoDBL# (P6R$)
  'If you really want documentation on these routines, ask Jason Boyd, author
  'of the AEdit/AExtern program. He wrote 'em, and I am only now gaining a
  'vague clue as to how they work, eh?
Man# = -1
P6RtoDBL# = 0
IF P6R$ = STRING$(6, 0) GOTO Zzero
Ex% = ASC(LEFT$(P6R$, 1)) - 128
Man# = (ASC(MID$(P6R$, 6, 1)) AND &H7F) / 128
IF ASC(RIGHT$(P6R$, 1)) > &H80 THEN Man# = Man# * -1
x# = .0078125
FOR T% = 5 TO 2 STEP -1
    x# = x# / 256
    Man# = Man# + (ASC(MID$(P6R$, T%, 1)) * x#)
    NEXT T%
P6RtoDBL# = (Man# + 1) * (2 ^ (Ex% - 1))
Zzero:
END FUNCTION

SUB Pstra (StringVal$)
  'Pstra is a beauty. It parses its parameter (StringVal$), and prints it
  'out, changing color along the way as it encounters TW2002 color codes.
  'It does not print a carriage return at the end--if you want to do this in
  'the same Pstra statement, use the ~! code, which is one of mine. (Pretty
  'much akin to putting \n in a string in C++)
  'I won't even *attempt* to document all of the string manipulation--have
  'fun trying to read my coding. <Grin> I'll document what I think are the key
  'parts you'll need to understand.
  'Pstra stands for Print STRing with color Attributes. It's a name I got
  'from the Telix SALT language, the name of a function that works completely
  'differently, but essentially does the same thing in output.
x = 1
DO
  CC% = INSTR(x, StringVal$, "~")
  'Checks to see if the tilde "~" exists in the string. If so, it goes on.
  IF CC% <> 0 THEN
    PRINT MID$(StringVal$, x, CC% - x);
    IF CC% < LEN(StringVal$) THEN
      CC% = CC% + 1
      x = CC% + 1
      A$ = MID$(StringVal$, CC%, 1)
    ELSE
      EXIT DO
    END IF
    SELECT CASE A$
      CASE "1"
        COLOR 11, 0
      CASE "2"
        COLOR 14, 0
      CASE "3"
        COLOR 5, 0
      CASE "4"
        COLOR 15, 1
      CASE "5"
        COLOR 2, 0
      CASE "6"
        COLOR 28, 0
      CASE "7"
        ForeGround = Forat(0, POS(0) - 1)
        IF ForeGround > 15 THEN ForeGround = ForeGround - 16
        COLOR ForeGround, 0
      CASE "8"
        ForeGround = Forat(0, POS(0) - 1)
        IF ForeGround < 16 THEN ForeGround = ForeGround + 16
        COLOR ForeGround
      CASE "9"
        ForeGround = Forat(0, POS(0) - 1)
        BackGround = Bakat(0, POS(0) - 1)
        IF ForeGround > 15 THEN ForeGround = ForeGround - 16
        IF ForeGround > 7 THEN ForeGround = ForeGround - 8
        COLOR BackGround, ForeGround
      CASE "0"
        COLOR 0, 0
'The horrid WWIV colors which I thought I was rid of years ago, and which
'Gary Martin has some obscene fascination with. Numbers 7 through 9 should
'now be accurate==I learned how to detect the current color and deal with
'it. Also keep in mind that I will not document all the colors following--
'if you're browsing this code and can't read a QB COLOR statement, you need
'help. :)
'
      CASE "a"
        COLOR 0, 0
      CASE "A"
        COLOR 8, 0
      CASE "b"
        COLOR 4, 0
      CASE "B"
        COLOR 12, 0
      CASE "c"
        COLOR 2, 0
      CASE "C"
        COLOR 10, 0
      CASE "d"
        COLOR 6, 0
      CASE "D"
        COLOR 14, 0
      CASE "e"
        COLOR 1, 0
      CASE "E"
        COLOR 9, 0
      CASE "f"
        COLOR 5, 0
      CASE "F"
        COLOR 13, 0
      CASE "g"
        COLOR 3, 0
      CASE "G"
        COLOR 11, 0
      CASE "h"
        COLOR 7, 0
      CASE "H"
        COLOR 15, 0
'The standard FG colors, all on a black BG. Note that with all, the uppercase
'is the bold version of the lowercase colors. Makes sense, actually.
'
      CASE "I"
        COLOR 1, 7
      CASE "J"
        COLOR 4, 7
      CASE "K"
        COLOR 14, 1
'A few miscellaneous codes which print various FG/BG combinations. One of
'them is used for the Taurean Mule.
'
      CASE "Z"
        COLOR 20, 7: PRINT ""; : COLOR 23, 4: PRINT ""; : COLOR 7, 0
          'The annoying flashing-double-Gary-Martin-box-from-hell which seems
          'to pepper TW2002 in order to get a player's attention.
'
      CASE "i"
        COLOR , 0
      CASE "j"
        COLOR , 4
      CASE "k"
        COLOR , 2
      CASE "l"
        COLOR , 6
      CASE "m"
        COLOR , 1
      CASE "n"
        COLOR , 5
      CASE "o"
        COLOR , 3
      CASE "p"
        COLOR , 7
'These codes change the background color *only*. If you need to use a FG/BG
'combination that there is no code for, change the foreground first and then
'issue one of these. IE, Blue on Green (Goddess forbid I ever see this color
'in actual use) would require ~E~k.
'
      CASE "q"
        COLOR 25, 0
'Nice, beautiful, and wonderfully-annoying-blinking-Escape-Pod-blue.
'
      CASE "r"
        COLOR 1, 0
'Don't ask me. The sole place I have ever seen this character is in the daily
'log, where it is used in EXTERN to change the header to blue. I included it
'for compatibility only.
'
      CASE "!"
        PRINT
'One of mine, one I'm shocked Gary neglected to include. (Maybe he did, and
'I just don't know it) Prints a carriage return.
'
      CASE "~"
        PRINT "~";
'I actually don't know whether or not this works in TW2002 or not. It would
'make sense, but I've never tested it. This prints an actual tilde, should
'you ever want to use one.
'
      CASE ELSE
        PRINT A$;
'If the following character was not a substitution code, print the actual
'character.
'
    END SELECT
  ELSE
    PRINT MID$(StringVal$, x, LEN(StringVal$) - x + 1);
    EXIT DO
      'Print all the characters remaining, and leave.
  END IF
LOOP
'
'The following remarked code is *only* of use to you if you plan to rewrite
'Pstra to output everything in ANSI instead of with COLOR statements. It
'is *not* stand-alone code, it is *not* guaranteed to work, and it requires
'that "CON" be opened for output as file #15. Have fun if you wish.
'Oh, it also has some code I was just starting to develop which takes any
'carets "^" and interprets the next character as a control code--IE, ^M for
'a carriage return. I had this in Pstra for a day or two, but I took it out
'because 1) I rarely used it, 2) I could just as easily make ~ codes for the
'ones I did, and 3) it was slowing Pstra down but good.
'
'        DD$ = DD$ + CHR$(27) + "[" + LTRIM$(STR$(A% - 8)) + "m"
'      CASE 56
'        DD$ = DD$ + CHR$(27) + "[5m"
'      CASE 57
'        DD$ = DD$ + CHR$(27) + "[0m"
'      CASE 65 TO 72
'        DD$ = DD$ + CHR$(27) + "[1;" + LTRIM$(STR$(A% - 35)) + "m"
'      CASE 97 TO 104
'        DD$ = DD$ + CHR$(27) + "[0;" + LTRIM$(STR$(A% - 67)) + "m"
'      CASE 92
'        DD$ = DD$ + "\"
'      CASE 88, 120
'        IF CC% < LEN(StringVal$) - 2 THEN
'          CC% = CC% + 1
'          X = CC% + 3
'          EE$ = MID$(StringVal$, CC%, 3)
'        ELSE
'          EXIT DO
'        END IF
'        DD$ = DD$ + CHR$(VAL(EE$))
'      CASE 78, 110
'        DD$ = DD$ + CHR$(13) + CHR$(10)
'      CASE 33
'        DD$ = DD$ + CHR$(27) + "[2J"
'      CASE 91
'        DD$ = DD$ + CHR$(27)
'      CASE ELSE
'        DD$ = DD$ + CHR$(A%)
'    END SELECT
'  ELSE
'    DD$ = DD$ + MID$(StringVal$, X, LEN(StringVal$) - X + 1)
'    EXIT DO
'  END IF
'LOOP
'
'  'ELSEIF A$ = "^" THEN
'  '  x = x + 1
'  '  IF x <= LEN(StringVal$) THEN A% = ASC(UCASE$(MID$(StringVal$, x, 1))) ELSE A% = 0
'  '  IF A% <= 91 AND A% >= 65 THEN PRINT CHR$(A% - 64);  ELSE PRINT CHR$(A%)
'  'ELSE
'  '  PRINT A$;
'  'END IF
'PRINT #15, DD$;
'
'
'FOR X = 1 TO LEN(StringVal$)
'  A$ = MID$(StringVal$, X, 1)
'  IF A$ = "~" THEN
'    X = X + 1
'    A$ = MID$(StringVal$, X, 1)
'    SELECT CASE A$
'      CASE "1"
'        COLOR 11, 0
'      CASE "2"
'        COLOR 14, 0
'      CASE "3"
'        COLOR 5, 0
'      CASE "4"
'        COLOR 15, 1
'      CASE "5"
'        COLOR 2, 0
'      CASE "6"
'        COLOR 28, 0
'      CASE "7"
'        COLOR 12, 0
'      CASE "8"
'        COLOR 28, 0
'      CASE "9"
'        COLOR 0, 4
'      CASE "a"
'        COLOR 0, 0
'      CASE "A"
'        COLOR 8, 0
'      CASE "b"
'        COLOR 4, 0
'      CASE "B"
'        COLOR 12, 0
'      CASE "c"
'        COLOR 2, 0
'      CASE "C"
'        COLOR 10, 0
'      CASE "d"
'        COLOR 6, 0
'      CASE "D"
'        COLOR 14, 0
'      CASE "e"
'        COLOR 1, 0
'      CASE "E"
'        COLOR 9, 0
'      CASE "f"
'        COLOR 5, 0
'      CASE "F"
'        COLOR 13, 0
'      CASE "g"
'        COLOR 3, 0
'      CASE "G"
'        COLOR 11, 0
'      CASE "h"
'        COLOR 7, 0
'      CASE "H"
'        COLOR 15, 0
'      CASE "I"
'        COLOR 1, 7
'      CASE "J"
'        COLOR 4, 7
'      CASE "K"
'        COLOR 14, 1
'      CASE "q"
'        COLOR 25, 0
'      CASE "Z"
'        COLOR 20, 7: PRINT ""; : COLOR 23, 4: PRINT ""; : COLOR 7, 0
'      CASE "~"
'        PRINT "~";
'      CASE ELSE
'        PRINT A$;
'    END SELECT
'  ELSEIF A$ = "^" THEN
'    X = X + 1
'    A$ = MID$(StringVal$, X, 1)
'    IF INSTR("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", A$) THEN
'      PRINT CHR$(ASC(UCASE$(A$)) - 64);
'    ELSEIF A$ = "^" THEN
'      PRINT "^";
'    ELSEIF A$ = "[" THEN
'      PRINT CHR$(27);
'    ELSE
'      PRINT A$;
'    END IF
'  ELSE
'    PRINT A$;
'  END IF
'NEXT X
END SUB

DEFINT A-Z
FUNCTION Sat$ (ScreenLine, ScreenColumn)
  'Sat$ returns the character preset at screen location ScreeLine,
  'ScreenColumn. These are the same values you would use in a LOCATE
  'statement.
  DEF SEG = &HB800
  DEFINT A-Z
  Offset = (((CSRLIN - 1) * 80) + POS(0)) * 2 - 2
    'Determine the offset from the current memory segment needed to get
    'the specified character.
  Sat$ = CHR$(PEEK(Offset))
    'Set the Sat$ function equal to that offset in memory.
END FUNCTION

DEFSNG A-Z
FUNCTION TWTtoBST$ (TWText$)
  'The function. (Duhwot?)
TWTtoBST$ = MID$(TWText$, 2, ASC(LEFT$(TWText$, 1)))
  'The QB string is set to the first x characters of TWText$, where TWText$
  'is the ASCII code (QB function ASC) of the Pascal prefix byte (the leftmost
  'character of TWText$).
END FUNCTION

