
'       TWMAP3.BAS:  TradeWars Galatic Charting Enhancement Package
'       Public Domain SoftWare by Kurt Holter, March 15, 1987
'       Modified to 80 column printout by Roger Gray, June 18, 1988
'       Modified to 1000 Sectors by Roger Gray, June 18, 1988
'
'       This ought to give all of you REAL programmers a good laugh...

	OPTION BASE 1
	DEFINT A-Z
	DIM S(1000, 15)
	CM$ = ","
	F1$ = "TST"
	F2$ = "TODAYS.LOG"
	f3$ = "TWREPORT"
	GOSUB NOTICE

BEGIN:
	GOSUB SCREENTOP
	LOCATE 12, 35
	PRINT "Help [N] ? ";
	GOSUB GETKEY
	GOSUB SCREENTOP
	IF INSTR("yY", A$) THEN GOSUB HELP

FILENAMES:
	PRINT "I need a 1-3 letter file extension for TWDATA.xxx,"
	PRINT "which will store all data gleaned from reading"
	PRINT "the .LOG file(s) ["; F1$;
	LINE INPUT "] : "; T$
	PRINT
	IF T$ <> "" THEN F1$ = T$
	PRINT "Enter the complete pathname for the .LOG file"
	PRINT "to be read ["; F2$;
	LINE INPUT "] : "; T$
	PRINT
	IF T$ <> "" THEN F2$ = T$
	PRINT "Finally, the name of the REPORT file to"
	PRINT "generate ["; f3$; "."; F1$;
	LINE INPUT "] : "; T$
	IF T$ <> "" THEN f3$ = T$ ELSE f3$ = "TWREPORT." + F1$
	GOSUB SCREENTOP
	PRINT "  Data file: TWDATA."; F1$
	PRINT "  .LOG file: "; F2$
	PRINT "Report file: "; f3$
	PRINT
	PRINT "All These Ok [Y] ? ";
	GOSUB GETKEY
	PRINT
	IF INSTR("Nn", A$) <> 0 THEN GOSUB SCREENTOP: GOTO FILENAMES

GOTO READFILE

INITFILE:
	GOSUB SCREENTOP
	LOCATE 12, 18
	PRINT "Create the new data file TWDATA."; F1$;
	LINE INPUT " [N] ? ", A$
	IF A$ = "" THEN GOTO BEGIN
	IF INSTR("nN", A$) THEN GOTO BEGIN
	GOSUB SCREENTOP
	LOCATE 12, 32
	PRINT "Creating TWDATA."; F1$
	NFLAG = 1
	LOCATE 14, 32
	PRINT "Writing Record No.";
	OPEN "TWDATA." + F1$ FOR OUTPUT AS #1
		FOR X = 1 TO 1000
			LOCATE 14, 52
			PRINT X;
			FOR Y = 1 TO 15
				PRINT #1, 0
			NEXT
		NEXT
CLOSE #1

	IF NFLAG = 1 THEN GOSUB SCREENTOP: GOTO SNATCHLOG

READFILE:
	GOSUB SCREENTOP
	ON ERROR GOTO INITFILE
	OPEN "TWDATA." + F1$ FOR INPUT AS #1
	LOCATE 12, 32
	PRINT "Reading TWDATA."; F1$
	LOCATE 14, 32
	PRINT "Reading Record No.";
	FOR X = 1 TO 1000
		LOCATE 14, 50
		PRINT X;
		FOR Y = 1 TO 15
		INPUT #1, S(X, Y)
		NEXT
	NEXT
CLOSE #1

ON ERROR GOTO 0

GOSUB COUNTUP
	OPC = PC
	OSC = SC
	OPL = PL
	PC = 0
	PL = 0
	SC = 0

SNATCHLOG:
	OPEN F2$ FOR INPUT AS #1
	GOSUB SCREENTOP
	LOCATE 12, 32
	PRINT "Reading "; F2$
	LOCATE 14, 32
	PRINT "Reading Line"

READLINE:
WHILE NOT EOF(1)
	LCTR = LCTR + 1
	LOCATE 14, 44
	PRINT ; LCTR
	LINE INPUT #1, L$
	IF LEFT$(L$, 5) = "Name:" THEN FOR WASTE = 1 TO 7: LINE INPUT #1, L$: NEXT WASTE
	IF LEFT$(L$, 7) = "Sector:" THEN GOSUB ADDSECTOR
	IF LEFT$(L$, 4) = "Port" THEN GOSUB ADDPORT
	IF LEFT$(L$, 7) = "Planet:" THEN GOSUB ADDPLANET
	IF LEFT$(L$, 14) <> "Warps lead to:" THEN GOTO READLINE

GETWARPS:
	FOR X = 5 TO 15
		S(SECTOR, X) = 0
	NEXT X
	L$ = MID$(L$, 15)

GETNEXT:
	S(SECTOR, 5) = S(SECTOR, 5) + 1
	P = INSTR(L$, CM$)
	IF P = 0 THEN S(SECTOR, 5 + (S(SECTOR, 5))) = VAL(MID$(L$, 2)): GOTO READLINE
	T$ = LEFT$(L$, P - 1)
	T = VAL(T$)
	CS = 5 + S(SECTOR, 5)
	S(SECTOR, CS) = T
	L$ = MID$(L$, P + 1)
GOTO GETNEXT

GOTO READLINE

WEND
	CLOSE #1
	GOSUB COUNTUP
	GOSUB SCREENTOP
	LOCATE 12, 32
	PRINT "Writing "; f3$
	LOCATE 14, 32
	PRINT "Record No.";
	OPEN f3$ FOR OUTPUT AS #1
	GOSUB HEADER

FOR X = 1 TO 1000
	IF S(X, 1) = 0 THEN GOTO NEWONE
	TSEC = TSEC + 1
	LC = LC + 1
	IF LC / 54 = INT(LC / 54) THEN PRINT #1, CHR$(12): GOSUB HEADER
	LOCATE 14, 42
	PRINT TSEC
	PRINT #1, "S:";
	PRINT #1, USING "####"; S(X, 1);
	PRINT #1, "|PT:";
	IF S(X, 2) > 0 THEN PRINT #1, USING "#"; S(X, 2);  ELSE PRINT #1, " ";
	IF S(X, 2) > 0 THEN TPT = TPT + 1
	PRINT #1, "|PL:";
	IF S(X, 3) > 0 THEN PRINT #1, "Y";  ELSE PRINT #1, " ";
	IF S(X, 3) > 0 THEN TPL = TPL + 1
	PRINT #1, "|W:";
	FOR Y = 1 TO S(X, 5)
		PRINT #1, USING "####"; S(X, Y + 5);
		IF S(S(X, Y + 5), 1) = 0 THEN PRINT #1, "?";  ELSE PRINT #1, " ";
		IF S(S(X, Y + 5), 2) > 0 THEN PRINT #1, "<"; RIGHT$(STR$(S(S(X, Y + 5), 2)), 1); ">";  ELSE PRINT #1, "   ";
		IF S(S(X, Y + 5), 3) > 0 THEN PRINT #1, "Y";  ELSE PRINT #1, " ";
	PRINT #1, "|";
	NEXT
	PRINT #1, ""

NEWONE:
	NEXT
	PRINT #1, ""
	IF LC > 45 THEN PRINT #1, CHR$(12): GOSUB HEADER
	PRINT #1, "  New Sectors Added: "; SC - OSC
	PRINT #1, "    New Ports Added: "; PC - OPC
	PRINT #1, "  New Planets Added: "; PL - OPL
	PRINT #1, ""
	PRINT #1, "Total Sectors Known: "; TSEC
	PRINT #1, "  Total Ports Known: "; TPT; "     ";
	FOR Y = 1 TO 3
		T = 0
		FOR X = 1 TO 1000
			IF S(X, 2) = Y THEN T = T + 1
		NEXT
		PRINT #1, "Class "; Y; ":"; T; "   ";
	NEXT
	PRINT #1, ""
	PRINT #1, "Total Planets Known: "; TPL
	PRINT #1, ""
	PRINT #1, "                              Have you hugged your fighters today?"
CLOSE #1

	GOSUB SCREENTOP
	LOCATE 12, 32
	PRINT "Writing TWDATA." + F1$
	LOCATE 14, 32
	PRINT "Record No.";
	OPEN "TWDATA." + F1$ FOR OUTPUT AS #1
	FOR X = 1 TO 1000
	LOCATE 14, 42
	PRINT X;
	FOR Y = 1 TO 15
		PRINT #1, S(X, Y)
	NEXT
NEXT
CLOSE #1
	GOSUB SCREENTOP
	LOCATE 12, 1
	PRINT "          "; f3$; " is an ASCII text file 80 columns wide."

END '******* SUBROUTINES FOLLOW *******************************************************

GETKEY:
	A$ = INKEY$
	IF A$ = "" THEN GOTO GETKEY
RETURN

SCREENTOP:
	CLS
	PRINT TAB(10); "TWMAPPER 3.1:  The Program for the Serious TradeWars Addict!"
	PRINT
RETURN

HELP:
	PRINT "TWMAPPER is a program designed to process TradeWars session log files."
	PRINT "It will generate and update a galactic chart which you may dump to your"
	PRINT "printer that contains a sorted listing of the following information for"
	PRINT "all known sectors of the universe:"
	PRINT
	PRINT "  *  The Sector Number"
	PRINT "  *  Port Class, If Any"
	PRINT "  *  Planet, If Any"
	PRINT
	PRINT "  ...and, the biggie:"
	PRINT
	PRINT "  *  This SAME information for each available warp from the particular"
	PRINT "     sector!  Additionally, warps leading to unknown sectors are flagged."
	PRINT
	PRINT "At the conclusion of a TWMAPPER run, both your updated database, as well"
	PRINT "as your updated report file are saved to disk."
	LOCATE 23, 60
	PRINT "Any Key...";
	GOSUB GETKEY
	GOSUB SCREENTOP
	PRINT "TWMAPPER is a utility designed for the serious TradeWars (The World's"
	PRINT "Greatest Game) player.  By logging one's daily game sessions while online,"
	PRINT "and saving each log file to disk, you automatically create files which will"
	PRINT "provide TWMAPPER with information to update a data file for each TradeWars"
	PRINT "game in which you participate."
	PRINT
	PRINT "You will need to create a SEPARATE database file for each TradeWars game"
	PRINT "that you play.  I call mine 'TWDATA.VIR' for the V.I.R.U.S. BBS game, and"
	PRINT "'TWDATA.BL' for the Baudline II game..."
	PRINT
	PRINT
	LOCATE 23, 60
	PRINT "Any Key...";
	GOSUB GETKEY
	GOSUB SCREENTOP
RETURN

HEADER:
	PRINT #1, "TWMAPPER:  The TradeWars Galactic Charting Enhancement Package"
	PRINT #1, "Last Update: "; TIME$; " on "; DATE$; "     Report File: "; f3$
	PRINT #1, "SECT PT CL PLANET WARP INFO: (? = Unk Sect, <n> = Class Port, Y = Pl in Sect)"
	PRINT #1, "-------------------------------------------------------------------------------"
	LC = 4
RETURN

NOTICE:
	GOSUB SCREENTOP
	PRINT "TWMAPPER is probably a rotten piece of code, elegance-wise.  I don't claim"
	PRINT "to be a even a remotely decent programmer.  Although originally written in"
	PRINT "the Microsoft QuickBASIC 2.01 environment, I purposely kept the code fairly"
	PRINT "generic to permit the source to be compiled or interpreted on"
	PRINT "as many machines as possible.  I have tested the source code under Microsoft"
	PRINT "BASIC 2.1 on my unenhanced 512K Mac, and it runs just fine (although"
	PRINT "as a disk-intensive application, it flies on my XTclone and hard disk."
	PRINT
	PRINT "If you enjoy playing TradeWars (The World's Greatest Game) then please"
	PRINT "consider doing two things:"
	PRINT
	PRINT "  *  The next time you log on to a BBS running TradeWars, take the time to"
	PRINT "     drop the SysOp a line and tell him how much you appreciate the game!"
	PRINT
	PRINT "  *  Urge him to provide a mailing address for Chris Sherrick, the author"
	PRINT "     of TradeWars.  Then, drop him a line and thank him for doing us all"
	PRINT "     such a fine service!"
	LOCATE 23, 60
	PRINT "Any Key...";
	GOSUB GETKEY
	GOSUB SCREENTOP
	LOCATE 10, 1
	PRINT "          Two fine RBBS-PC Systems running TradeWars as of 03-14-87:"
	PRINT
	PRINT "     V.I.R.U.S. (301) 293-1959                 Baudline II (301) 694-7108"
	PRINT
	PRINT
	PRINT
	PRINT "          Good Luck.  It's time we all got serious about TradeWars!"
	PRINT
	PRINT "Kurt 'See you in the Known Universe' Holter                      March 1987"
	LOCATE 23, 60
	PRINT "Any Key...";
	GOSUB GETKEY
RETURN

ADDSECTOR:
	SECTOR = VAL(MID$(L$, 8))
	S(SECTOR, 1) = SECTOR
	FOR ZZ = 2 TO 15
		S(SECTOR, ZZ) = 0
	NEXT
RETURN

ADDPORT:
	S(SECTOR, 2) = VAL(RIGHT$(L$, 1))
RETURN

ADDPLANET:
	S(SECTOR, 3) = 1
RETURN

COUNTUP:
	FOR X = 1 TO 1000
		IF S(X, 2) > 0 THEN PC = PC + 1
		IF S(X, 1) > 0 THEN SC = SC + 1
		IF S(X, 3) > 0 THEN PL = PL + 1
	NEXT
RETURN

'***** END OF SOURCE FILE *****

