{$S+,R+,V-}
{$M 65520, 0, 200000}
Program Twft;
uses
  Crt,Dos,FlyCom,TwScr,
  FlyMenu,FParser,TwBuffer,XModem,TwAnsi,
  TwDialer,TwInp,TwTrade,TwTrad2,TwLaunch,TwMap,TwUch,ExecSwap;


 const
   Debug:boolean= FALSE;
   SwapLoc : array[Boolean] of String[7] = ('on disk', 'in EMS');
   ColorNames: Array[0 .. 15] of string[15] = (
                                               'Black',
                                               'Blue',
                                               'Green',
                                               'Cyan',
                                               'Red',
                                               'Magenta',
                                               'Brown',
                                               'LightGray',
                                               'DarkGray',
                                               'LightBlue',
                                               'LightGreen',
                                               'LightCyan',
                                               'LightRed',
                                               'LightMagenta',
                                               'Yellow',
                                               'White');

 type
   ColorArray = ARRAY[0 .. 10] of Byte;
 var
   NotDoneYet,isEcho,isKeyPad : Boolean;
   PStringMain : string;
   Pmain : ParseType;
   M : MenuType;
   Port,i,count,Tokens : Integer;
   BaudRate : Word;
   Charin : Char;
   StripHighBit : Byte;
   DefaultDelay : Word;
   RollerFcolors, RollerBcolors : colorarray;
   Modem : text;
   SepStr : string;
   TwExec : string;
   TwCfgBeenRead : boolean;


  Procedure ToggleStripHighBit;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    If (StripHighBit = $FF) then begin
      Write(' Stripping ON ');
      StripHighBit := $7F;
    END
    Else BEGIN
      StripHighBit := $FF;
      Write(' Stripping OFF ');
    END;
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;

  Procedure ToggleAnsiOn;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    AnsiOn := (NOT AnsiOn);
    If AnsiOn then
      Write(' ANSI On ')
    Else Write(' ANSI Off ');
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;


  Procedure ToggleEchoOn;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    isEcho := (NOT isEcho);
    If isEcho then
      Write(' ECHO On ')
    Else Write(' ECHO Off ');
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;

  Procedure ToggleDebugOn;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    Debug := (NOT Debug);
    If Debug then
      Write(' DEBUG On ')
    Else Write(' DEBUG Off ');
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;

  Procedure ToggleKeyPad;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    isKeyPad := (NOT isKeyPad);
    If isKeyPad then
      Write(' KEYPAD On ')
    Else Write(' KEYPAD Off ');
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;

  Procedure ToggleInputLine;
    var
      X,Y : integer;
  BEGIN
    SaveScreen(X,Y);
    SelectWindow(1);
    ClrScr;
    InputLine := (NOT InputLine);
    If InputLine then
      Write(' INPUT LINE Activated ')
    Else Write(' INPUT LINE Off ');
    Delay(1000);
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
    If InputLine then
      RestoreInputString
    else TopLine;
  END;

  Procedure SetParams;
  label
    TheEnd;
  var
    X,Y : integer;
    R : RealArray;
    A : char;
    c : char;

  BEGIN
    SaveScreen(X,Y);
    TextColor(LightRed);
    TextBackGround(Black);
    ClrScr;
    WriteLn(' Enter a value (in seconds) for the Dialer Delay Time. ');
    WriteLn(' 4.0 is the default value.');
    WriteLn;
    WriteLn(' The acceptable range of values is 3.0 seconds to 9.9 seconds ');
    WriteLn;
    REPEAT
      if GetReals(1,R) then
        DelayTime := R[1];
      If (DelayTime < 3.0) then
        WriteLn(' R too small.  Enter another value ');
      If (DelayTime > 9.9) then
        WriteLn(' R too large.  Enter another value ');
    UNTIL (DelayTime >= 3.0) and (DelayTime <= 20.0);
    PressEnter(c);
    if c = #27 then goto TheEnd;
    REPEAT
      ClrScr;
      TextColor(LightRed);
      WriteLn(' Enter values for the buy and sell margins in the trade macro ');
      TextColor(Green);
      WriteLn;
      WriteLn(' The buy margin is multiplied into the port bid to create');
      WriteLn(' the first offer by the trade macro.  Likewise, the first');
      WriteLn(' port bid on the sale of any item is multiplied by the');
      WriteLn(' sell margin to create the first macro offer.');
      WriteLn;
      WriteLn(' 0.96 is the default for Buy, 1.04 for Sell ');
      WriteLn;
      WriteLn(' Acceptable ranges for values are: ');
      WriteLn;
      WriteLn(' Buy margin  : 0.900 to 0.999');
      WriteLn(' Sell margin : 1.000 to 1.100');
      WriteLn;
      TextColor(LightRed);
      if GetReals(2,R) then begin
        DefaultBuy := R[1];
        DefaultSell := R[2];
      end;
    UNTIL ((DefaultBuy > 0.899) and (DefaultBuy < 1.0)) and
          ((DefaultSell > 0.9999) and (DefaultSell <= 1.10));
    PressEnter(c);
    if c = #27 then goto TheEnd;
    REPEAT
      ClrScr;
      TextColor(LightRed);
      WriteLn(' Enter values for the trading factor  ');
      TextColor(Green);
      WriteLn;
      WriteLn(' This program uses the product of the trading factor');
      WriteLn(' and the port bid differences to adjust subsequent');
      WriteLn(' bids. Theory suggests 2.333333 as the best value. ');
      WriteLn;
      WriteLn(' Acceptable ranges for values are: ');
      WriteLn;
      WriteLn(' Factor: 1.0 to 5.0 ');
      WriteLn;
      TextColor(LightRed);
      If GetReals(1,R) then
        DefaultFactor := R[1];
    UNTIL ((DefaultFactor > 0.99999) and (DefaultFactor < 5.0001 ));
    PressEnter(c);
    if c = #27 then goto TheEnd;
    REPEAT
      ClrScr;
      TextColor(LightRed);
      WriteLn(' Enter the differences required to alter trading factor:');
      TextColor(Green);
      WriteLn;
      WriteLn(' This program uses the difference between port offers');
      WriteLn(' to decide when to change FACTOR.  There are 2 different');
      WriteLn(' numbers involved, a delta offer and a delta psp.');
      WriteLn(' If the numbers are too large, FACTOR never changes.');
      WriteLn(' If the numbers are too small, FACTOR always changes and is');
      WriteLn(' never accurately defined.  The *best* values for these terms');
      WriteLn(' are currently unknown.');
      WriteLn;
      WriteLn(' Default values are 25 for delta offer and 4 for delta psp.');
      WriteLn;
      WriteLn(' Acceptable ranges for values are: ');
      WriteLn;
      WriteLn(' Delta Offer: 1 to 100 ');
      WriteLn(' Delta Psp  : 1 to 100 ');
      WriteLn;
      TextColor(LightRed);
      If GetReals(2,R) then begin
        DeltaFactorOffer := round(R[1]);
        DeltaFactorPsp := round(R[2]);
      end;
    UNTIL ((DeltaFactorOffer > 0) and (DeltaFactorOffer < 101 ) and
          (DeltaFactorPsp > 0) and (DeltaFactorPsp < 101 ));
    PressEnter(c);
    if c = #27 then goto TheEnd;

    REPEAT
      ClrScr;
      TextColor(LightRed);
      WriteLn(' Enter the factor you wish to multiply into your experience');
      WriteLn(' in order to determine how much cash you can rob:');
      TextColor(Green);
      WriteLn;
      WriteLn;
      WriteLn(' The default is 5.0.  Values from 0.05 to 10.0 are accepted. ');
      WriteLn(' The current value equals ',RobFactor:8:3);
      WriteLn;
      TextColor(LightRed);
      If GetReals(1,R) then begin
        RobFactor := R[1];
      end;
    UNTIL ((RobFactor > 0.04999) and (RobFactor < 10.001 ));
    PressEnter(c);
    if c = #27 then goto TheEnd;

    REPEAT
      ClrScr;
      TextColor(LightRed);
      WriteLn(' Enter the number of times to vary the root in a LD:');
      TextColor(Green);
      WriteLn;
      WriteLn(' This variable sets the number of times to alter root');
      WriteLn(' in the variable root algorithm. ');
      WriteLn;
      WriteLn(' The default is 10.  Values from 3 to 100 are accepted. ');
      WriteLn;
      TextColor(LightRed);
      If GetReals(1,R) then begin
        VarRootChanges := round(R[1]);
      end;
    UNTIL ((VarRootChanges > 2) and (VarRootChanges < 101 ));
    PressEnter(c);
    if c = #27 then goto TheEnd;
TheEnd:
    NormalVideo;
    RestoreScreen;
    SelectWindow(2);
    GoToXY(X,Y);
  END;

  Procedure BufferControl;
  var
    M : MenuType;
    i,X,Y : integer;
  BEGIN
    M.choices := 4;
    M.S[1] := 'Open Buffer';
    M.S[2] := 'Close Buffer';
    M.S[3] := 'Save Buffer';
    M.S[4] := 'Upload text file';
    SaveScreen(X,Y);
    EscapeFlagOn;
    OneLineBox;
    i := Menu(30,2,M);
    RestoreScreen;
    NormalVideo;
    Case i of
     1: OpenBuffer;
     2: CloseBuffer;
     3: BEGIN
          SelectWindow(2);
          ClrScr;
          SaveBuffer;
        END;
     4: OpenUploadFile;
    END; { case }
    ToWindow2(X,Y);
  END; { BufferControl }

Procedure ViewFile;
label
  ViewExit;
var
  S : string;
  C : char;
  io,j,X,Y : integer;
  F : text;

BEGIN
  TextColor(White);
  TextBackGround(Blue);
  SaveScreen(X,Y);
  SelectWindow(1);
  ClrScr;
  Write(' === ALT V -- VIEWING TEXT FILE === ');
  SelectWindow(2);
  GoToXY(X,Y);
  WriteLn;
  WriteLn(' Name of File To Be Viewed?');
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        WriteLn(' Invalid Filename.  New Name for Text File?');
        BuildString(S);
        If S = '' then
          Goto ViewExit;
      end
    UNTIL (io = 0);
    REPEAT
      ClrScr;
      j := 0;
      While NOT EOF(F) and (j <= 20) do
        BEGIN
          ReadLn(F,S);
          WriteLn(S);
          Inc(j);
        END;
      IF Not EOF(F) Then BEGIN
        WriteLn;
        WriteLn(' Press Enter to Continue ');
        ReadLn(S);
      END
      ELSE Begin
        WriteLn;
        WriteLn(' Press Enter to Exit ');
        ReadLn(S);
      END;
    UNTIL EOF(F);
  end;
ViewExit:
  NormalVideo;
  RestoreScreen;
  GotoXY(X,Y);
END;


Procedure ViewGameScript;
label
  ViewGameExit;
var
  temp : boolean;
  S,DT : string;
  C,KC : char;
  DelayTime : real;
  MyDelay : word;
  io,j,X,Y,XX,YY,Ec : integer;
  F : text;

BEGIN
  temp := AnsiOn;
  AnsiOn := TRUE;
  SaveScreen(X,Y);
  TextColor(Blue);
  TextBackGround(LightCyan);
  SelectWindow(1);
  ClrScr;
  Write('=== ALT G-View Game Script. ');
  TextColor(Magenta);
  Write('SPACE ');
  TextColor(Blue);
  Write('Pauses. ');
  TextColor(Red);
  Write('D');
  TextColor(Blue);
  Write(' Changes Delay. ');
  TextColor(Black);
  Write('ESC');
  TextColor(Blue);
  Write(' Quits ===');
  TextColor(White);
  TextBackGround(Blue);
  SelectWindow(2);
  ClrScr;
  SaveScreen(XX,YY);
  WriteLn;
  WriteLn(' Name of File To Be Viewed?');
  BuildString(S);
  If S <> '' then begin
    REPEAT
      Assign(F,S);
      {$I-} Reset(F); {$I+}
      io := ioresult;
      if io <> 0 then begin
        WriteLn(' Invalid Filename.  New Name for Game Script?');
        BuildString(S);
        If S = '' then begin
          RestoreScreen;
          Goto ViewGameExit;
        end;
      end
    UNTIL (io = 0);
    REPEAT
      GoToXY(1,10);
      WriteLn;
      WriteLn(' Amount of Time to Delay Each Character in Seconds?');
      WriteLn(' DEFAULT = 0.005 ');
      BuildString(DT);
      Val(DT,DelayTime,Ec);
      If Ec <> 0 then
        DelayTime := 0.005;
      MyDelay := Round(1000*DelayTime);
      If ((DelayTime < 0.0) or (DelayTime >= 5.0)) then begin
        GoToXY(1,20);
        TextColor(White);
        TextBackGround(Red);
        WriteLn(' Improper delay time.  Delay should be at least ');
        WriteLn(' zero seconds and less than five seconds.       ');
        TextColor(White);
        TextBackGround(Blue);
      end;
    UNTIL ((DelayTime >= 0.0) and (DelayTime < 5.0));
    RestoreScreen;
    ClrScr;
    While NOT EOF(F) do begin
      Read(F,C);
      If (C = #27) then
        File_Ansi(F)
      Else Write(C);
      KC := #0;
      If KeyPressed then
        KC := ReadKey;
      If KC = ' ' then begin
        SaveScreen(XX,YY);
        GoToXY(40,24);
        TextColor(White);
        TextBackGround(Red);
        Write(' Press Space to Continue ');
        REPEAT
          KC := ReadKey;
        UNTIL (KC = ' ');
        TextColor(White);
        TextBackground(Blue);
        RestoreScreen;
        GotoXY(XX,YY);
      end;
      If ((KC = 'D') or (KC = 'd')) then begin
        SaveScreen(XX,YY);
        TextColor(Blue);
        TextBackground(White);
        ClrScr;
        REPEAT
          GoToXY(1,10);
          TextColor(Blue);
          TextBackground(White);
          WriteLn;
          WriteLn(' Amount of Time to Delay Each Character in Seconds?');
          WriteLn(' DEFAULT = 0.005 ');
          BuildString(DT);
          Val(DT,DelayTime,Ec);
          If Ec <> 0 then
            DelayTime := 0.005;
          MyDelay := Round(1000*DelayTime);
          If ((DelayTime < 0.0) or (DelayTime >= 5.0)) then begin
            GoToXY(1,20);
            TextColor(Red);
            WriteLn(' Improper delay time.  Delay should be at least ');
            WriteLn(' zero seconds and less than five seconds.       ');
            TextColor(White);
            TextBackGround(Blue);
          end;
        UNTIL ((DelayTime >= 0.0) and (DelayTime < 5.0));
        TextColor(White);
        TextBackground(Blue);
        RestoreScreen;
        GotoXY(XX,YY);
      end;
      If (KC = #27) then begin
        Close(F);
        Goto ViewGameExit;
      end;
      Delay(MyDelay);
    END;
    IF EOF(F) Then BEGIN
      GoToXY(1,22);
      WriteLn;
      WriteLn(' =================== ');
      Write(' Press Enter to Exit ');
      ReadLn(S);
    END;
    Close(F);
  end { If S ... }
  Else RestoreScreen;
ViewGameExit:
  NormalVideo;
  ClrScr;
  RestoreScreen;
  Towindow2(X,Y);
  AnsiOn := temp;
END;

Procedure ChooseDnlProto;
var
  X,Y,i : integer;
  M : MenuType;
  t : boolean;
  com : word;
  baud : longint;

BEGIN
  SaveScreen(X,Y);
  TextColor(LightMagenta);
  TextBackGround(Blue);
  com := port and $FF;
  baud := baudrate and $0000FFFF;
  M.Choices := 4;
  M.S[1] := 'a) XModem Crc ';
  M.S[2] := 'b) 1K XModem';
  M.S[3] := 'c) YModem';
  M.S[4] := 'd) YModem Batch';
  EscapeFlagOn;
  OneLineBox;
  FillBox(5,5,' Choose One');
  i := Menu(20,10,M);
  RestoreScreen;
  Case i of
    1: ReceiveXmodem;
    2,3: ReceiveYModemBatch(FALSE);
    4: ReceiveYModemBatch(TRUE);
  end;
  NormalVideo;
  ToWindow2(X,Y);
END;


Procedure ChooseUplProto;
var
  X,Y,i : integer;
  M : MenuType;

BEGIN
  SaveScreen(X,Y);
  TextColor(LightMagenta);
  TextBackGround(Blue);
  M.Choices := 4;
  M.S[1] := 'a) XModem Crc';
  M.S[2] := 'b) 1K-Xmodem';
  M.S[3] := 'c) YModem ';
  M.S[4] := 'd) YModem Batch';
  EscapeFlagOn;
  OneLineBox;
  FillBox(5,5,' Choose One ');
  i := Menu(20,10,M);
  RestoreScreen;
  Case i of
    1: TransmitXmodem(BaudRate);
    2,3: TransmitYModemBatch(BaudRate,FALSE);
    4: TransmitYModemBatch(BaudRAte,TRUE);
  end;
  NormalVideo;
  ToWindow2(X,Y);
END;

Procedure ReadShellCfg;
const
  ShellCfg = 'TWFT.CFG';
  OtherCfg = 'TWSHELL.CFG';
var
  F : text;
  io : integer;
  S : string;
  P : ParseType;
  toks : integer;
  tokstr : string;
BEGIN
  tokstr := ' ='+#10+#13+#8+#9;
  TwCfgBeenRead := FALSE;
  Assign(F,ShellCfg);
  {$I-} Reset(F); {$I+}
  io := ioresult;
  if io = 0 then begin
    ReadLn(F,S);
    Close(F);
    toks := Parse_Str(tokstr,S,P);
    if toks > 0 then begin
      TwExec := P.s[toks-1];
      TwCfgBeenRead := TRUE;
    end;
  end
  else begin
    Assign(F,OtherCfg);
    {$I-} Reset(F); {$I+}
    io := ioresult;
    if io = 0 then begin
      ReadLn(F,S);
      Close(F);
      toks := Parse_Str(tokstr,S,P);
      if toks > 0 then begin
        TwExec := P.s[toks-1];
        TwCfgBeenRead := TRUE;
      end;
    end
  end; { else }
END;


Function ReadComCfg(var Port : Integer; var Baud : Word) : Boolean;
const
  ComCfg = 'TWFT.CFG';
  OtherCfg = 'TWSHELL.CFG';
var
  F : text;
  j, k, io : integer;
  S : string;
  P : ParseType;
  toks : integer;
  tokstr : string;
  ec1 : Integer;
  t : Boolean;

BEGIN
  tokstr := ' ='+#10+#13+#8+#9;
  t := FALSE;
  if (ParamCount > 1) then begin
    k := 0;
    for j := 1 to ParamCount-1 do begin
      if MatchToken(ParamStr(j),'port') then begin
        Val(ParamStr(j+1),Port,ec1);
        if ec1 = 0 then Inc(k);
      end;
      if MatchToken(ParamStr(j),'speed') then begin
        Val(ParamStr(j+1),Baud,ec1);
        if ec1 = 0 then Inc(k);
      end;
    end; { for j }
    if (k > 1) then
     t := TRUE;
  end;
  if NOT t then begin
  Assign(F,ComCfg);
  {$I-} Reset(F); {$I+}
  io := ioresult;
  if io = 0 then begin
    ReadLn(F,S);
    ReadLn(F,S);
    Close(F);
    toks := Parse_Str(tokstr,S,P);
    if (toks = 2) then begin
      Port := Ord(P.s[0][4]) - Ord('0');
      Val(P.s[1],Baud,ec1);
      If ec1 = 0 then
        t := TRUE;
    end;
  end
  else begin
    Assign(F,OtherCfg);
    {$I-} Reset(F); {$I+}
    io := ioresult;
    if io = 0 then begin
      ReadLn(F,S);
      ReadLn(F,S);
      Close(F);
      toks := Parse_Str(tokstr,S,P);
      if (toks = 2) then begin
        Port := Ord(P.s[0][4]) - Ord('0');
        Val(P.s[1],Baud,ec1);
        If ec1 = 0 then
          t := TRUE;
      end;
    end;
  end; { else begin }
  end; { if not t }
  ReadComCfg := t;
END;



Procedure MyDosShell;
var
  X,Y,A,B : integer;
  Status : word;
BEGIN
    SaveScreen(X,Y);
    Window(1,1,80,25);
    ClrScr;
    if (NOT TwCfgBeenRead) then begin
      SaveScreen(A,B);
      TextColor(LightCyan);
      TextBackground(Blue);
      GotoXY(5,5);Write('                                                         ');
      GotoXY(5,6);Write(' Enter the full path and name of program to be executed. ');
      GotoXY(5,7);Write(' for example C:\TWUTILS\TWASSIST.EXE or C:\COMMAND.COM   ');
      GotoXY(5,8);Write('                                                         ');
      TextColor(LightCyan);
      TextBackground(Blue);
      GotoXY(5,10);Write('                                                         ');
      GotoXY(6,10);
      BuildString(Twexec);
      RestoreScreen;
      GoToXY(A,B);
    end;
    If (length(Twexec) > 0) then begin
      FlushBuffer;
      UseEmsIfAvailable := True;
      if not InitExecSwap(HeapPtr, 'SWAP.$$$') then begin
        WriteLn('Unable to allocate swap space.');
        Delay(2000);
      end
      else begin
        TextColor(LightRed);
        TextBackground(Black);
        ClrScr;
        WriteLn('Allocated ', BytesSwapped, ' bytes ', SwapLoc[EmsAllocated]);
        WriteLn;
        TextColor(LightCyan);
        WriteLn;
        SwapVectors;
        Status := ExecWithSwap(Twexec, '');
        ShutDownExecSwap;
        SwapVectors;
        InitBuffer;
      end;
    end;
    RestoreScreen;
    SelectWindow(2);
    NormalVideo;
    GotoXY(X,Y);
END;

Procedure CityHelp;
var
  X,Y : integer;
  c : char;

Procedure C0;
BEGIN
  TextColor(LightRed);
  TextBackGround(Black);
END;


Procedure C1;
BEGIN
  TextColor(Yellow);
  TextBackGround(Black);
END;

Procedure C2;
BEGIN
  TextColor(Cyan);
  TextBackGround(Black);
END;

Procedure C3;
BEGIN
  TextColor(Green);
  TextBackGround(Black);
END;

BEGIN
  SaveScreen(X,Y);
  C0;
  ClrScr;
  WriteLn('        Tradewars Freeware Terminal Help Screen ');
  WriteLn;
  DrawLine(2,2);
  WriteLn('   Function Keys       Alt Keys               Tradewars Commands');
  WriteLn;
  DrawLine(2,4);
  GotoXY(1,5);
  C1;Write('  F1 -');C2;Write('Help            ');C1;
  Write('ALT A-');C2;Write('Toggle ANSI      ');  C1;Write('ALT 5-');C3;WriteLn('5 Pt. Steal Macro');
  C1;Write('  F2 -');C2;Write('Open Buffer     ');C1;
  Write('ALT C-');C2;Write('Clear Screen     ');  C1;Write('ALT 6-');C3;WriteLn('Multi-Steal Macro');
  C1;Write('  F3 -');C2;Write('Close Buffer    ');C1;
  Write('ALT D-');C2;Write('Dial BBS         ');  C1;Write('ALT 7-');C3;WriteLn('Half-Steal Macro');
  C1;Write('  F4 -');C2;Write('Save Buffer     ');C1;
  Write('ALT E-');C2;Write('Toggle Echo      ');  C1;Write('ALT L-');C3;WriteLn('Launch Macros');
  C1;Write('  F5 -');C2;Write('CIM Capture     ');C1;
  Write('ALT F-');C2;Write('Directory        ');  C1;Write('ALT R-');C3;WriteLn('Rob Macro');
  C1;Write('  F6 -');C2;Write('Text Upload     ');C1;
  Write('ALT G-');C2;Write('View Game Script ');  C1;Write('ALT S-');C3;WriteLn('Steal Macro');
  C1;Write('  F8 -');C2;Write('Recall Inp Line ');C1;
  Write('ALT H-');C2;Write('Toggle 8th bit   ');  C1;Write('ALT T-');C3;WriteLn('Trade Macro');
  C1;Write('  F10-');C2;Write('Set Term Parms  ');C1;
  Write('ALT I-');C2;Write('Input Line Mode  ');  C1;Write('ALT 1-');C3;WriteLn('One Port Trade');
  C0;Write('                      ');C1;
  Write('ALT J-');C2;Write('Redial BBS       ');  C1;Write('ALT Q-');C3;WriteLn('Partial Lvl Diag');
  C0;Write('                      ');C1;
  Write('ALT N-');C2;Write('Run Extern Prgm  ');  C1;Write('ALT W-');C3;WriteLn('Lvl Diag Macro');
  C0;Write('                      ');C1;
  Write('ALT V-');C2;Write('View Text File   ');  C1;Write('ALT Y-');C3;WriteLn('Set TW Help File');
  C0;Write('                      ');C1;
  Write('ALT X-');C2;Write('Exit Program     ');  C1;Write('ALT Z-');C3;WriteLn('TW Tips & Help');
  C0;Write('                      ');C1;
  Write('      ');C2;Write('                 ');  C1;Write('F5   -');C3;WriteLn('CIM Capture ');
  WriteLn;
  C0;
  DrawLine(2,19);
  c := ReadKey;
  NormalVideo;
  RestoreScreen;
  GotoXY(X,Y);
END;

  PROCEDURE ExtKeyProcs;
  VAR
    X,Y,A,B : integer;
    c : Char;
    S : string;
    Z,Done : boolean;
    Status : Word;

  BEGIN
    c := ReadKey;
    Done := True;
    REPEAT
    CASE c OF
{      #15 : }                  {sh-Tab}
{        ;   }
      #59 :                   { F1 }
        CityHelp;
      #84 :                   {sh-F1}
        DialNumber(Modem);
      #60 :                   { F2 }
        OpenBuffer;
      #61 :                   { F3 }
        CloseBuffer;
      #62 :                   { F4 }
        SaveBuffer;
      #63 :                   { F5 }
        CIMCapture;
      #64 :                   { F6 }
        BufferControl;
      #88 :                   { Sh-F5 }
        ;
      #89 :                   { Sh-F6 }
        ;
      #65 :                   { F7 }
        ;
      #66 :                   { F8 }
        RecallS;
      #67 :                   { F9 }
        ;
      #68 :                   { F10 }
        SetParams;
      #72 :                   { up arrow }
        ;
      #80 :                   { down arrow }
        ;
      #77 :                   {right arrow }
        ;
      #75 :                   { left arrow }
        ;
      #71 :                   { home  }
        ;
      #73 :                   { Pg Up }
          ChooseUplProto;
      #79 :                   { End   }
        ;
      #81 :                   { Pg Dn }
          ChooseDnlProto;
      #30 :                   {ALT-A}
        ToggleAnsiOn;
      #46 :                   {ALT-C}
        BEGIN
          TextColor(White);
          TextBackGround(Black);
          ClrScr;
        END;
      #32 :                   {ALT-D}
        ReDialNumber(Modem,45);
      #18 :                   {ALT-E}
        ToggleEchoOn;
      #33 :                   {ALT-F}
        BEGIN
          SaveScreen(X,Y);
          ReadDirectory;
          RestoreScreen;
          ToWindow2(X,Y);
        END;
      #34 :                   {ALT-G}
        ViewGameScript;
      #35 :                   {ALT-H}
        ToggleStripHighBit;
      #23 :                   {ALT-I}
        ToggleInputLine;
      #36 :                   {ALT-J}
        ReDialNumber(Modem,45);
      #37 :                   {ALT-K}
        ;
      #38 :                   {ALT-L}
        BEGIN
          LaunchStuff;
          if InputLine then begin
            InputLine := FALSE;
            TopLine;
          end;
        END;
      #50 :                   {ALT-M}
        ;
      #49 :                   {ALT-N}
         MyDosShell;
      #16 :                   {ALT-Q}
        ParseMap(FALSE);
      #19 :                   {ALT-R}
        BEGIN
          RobAPort;
          TopLine;
        END;
      #120 :                  {ALT-1}
        BEGIN
          OnePortTrade;
          TopLine;
        END;
      #124 :                  {ALT-5}
        BEGIN
          FivePointSteal;
          TopLine;
        END;
      #125 :                  {ALT-6}
        BEGIN
          MultiSteal;
          TopLine;
        END;
      #126 :                  {ALT-7}
        BEGIN
          HalfSteal;
          TopLine;
        END;
      #31 :                   {ALT-S}
        BEGIN
          Steal;
          TopLine;
        END;
      #20 :                   {ALT-T}
        BEGIN
          Trade;
          TopLine;
        END;
      #47 :                   {ALT-V}
        ViewFile;
      #17 :                   {ALT-W}
        ParseMap(TRUE);
      #45 :                   {ALT-X}
        BEGIN
          SaveScreen(X,Y);
          TextColor(White);
          TextBackground(Red);
          GoToXY(25, 9);Write('                                    ');
          GotoXY(25,10);Write(' Do You REALLY Want To Quit Y/N?    ');
          GotoXY(25,11);Write('                                    ');
          TextColor(Yellow);
          GotoXY(57,10);
          ReadLn(S);
          if S <> '' then
            If (S[1] = 'y') or (S[1] = 'Y') then
              NotDoneYet := FALSE;  { quit flag}
          RestoreScreen;
          NormalVideo;
          GotoXY(X,Y);
        END;
      #21 :                   {ALT-Y}
        SetHelpFile;
      #44 :                   {ALT-Z}
        TradeHelp;
      #131:                    {Alt = (ALT +)}
        ToggleDebugOn;
    END;                      { case }
    Until Done;
  END;                        { escape procedures }

BEGIN
  isEcho := FALSE;
  Debug := FALSE;
  isKeyPad := FALSE;
  StripHighBit := $FF;
  NotDoneYet := TRUE;
  InputLine := FALSE;
  DefaultDelay := 5;
  TextColor(White);
  TextBackGround(Blue);
  ClrScr;
  InitBuffer;
  TerminalPkg := cityterm;
  PstringMain := '';
  Charin := #0;
  Twexec := '';
  SepStr := ' '+#9+#10+#13;
  SetLimits(1,1,80,24);
  If NOT ReadComCfg(Port,BaudRate) then begin
    TextColor(White);
    TextBackGround(Blue);
    FillBox(2,2,'Choose Modem Port');
    M.choices := 4;
    M.s[1] := '1) Com1 (external modem)';
    M.s[2] := '2) Com2 (internal modem)';
    M.s[3] := '3) Com3 (internal modem)';
    M.s[4] := '4) Com4 (internal modem)';
    Port := Menu(30,10,M);
    FillBox(2,2,'Choose Baud Rate ');
    M.choices := 5;
    M.s[1] := '300';
    M.s[2] := '1200';
    M.s[3] := '2400';
    M.s[4] := '9600';
    M.s[5] := '19200';
    M.s[6] := '38400';
    M.s[7] := '57600';
    i := Menu(20,10,M);
    Case i Of
      1: BaudRate := 300;
      2: BaudRate := 1200;
      3: BaudRate := 2400;
      4: BaudRate := 9600;
      5: BaudRate := 19200;
      6: BaudRate := 38400;
      7: BaudRate := 57600;
    END;
  end;
  AssignModem(Modem,Port,BaudRate,'N',8,1);
  Rewrite(Modem);
  InitDialer('TWDIAL.LST',Modem);
  com_raise_dtr;
  Delay(500);
  If NOT Async_Carrier_Detect then
    Com_Flush_Rx;
  IBMSetup;
  ScreenSetup;
  M.choices := 7;
  M.S[1] := 'F1-Help';
  M.S[2] := 'F2-Open';
  M.S[3] := 'F3-Close';
  M.S[4] := 'F4-Save';
  M.S[5] := 'F5-CIM   ';
  M.S[6] := 'PgUp-Upload';
  M.S[7] := 'PgDn-DnLoad';
  FindUnique(M);
  M.u[1] := 2;
  M.u[6] := 4;
  M.u[7] := 4;
  SelectWindow(1);
  LineDisplay(1,1,M);
  SelectWindow(2);
  NormalVideo;
  GotoXY(1,1);
  ReadShellCfg;
  ClrScr;
  count := 0;
  WHILE NotDoneYet DO
    BEGIN
      If Async_Receive(CharIn) then
        BEGIN
          CharIn := Chr( Ord(CharIn) And StripHighBit);
          If BufferisOpen then
            AddToBuffer(CharIn);
          If (CharIn = #27) and AnsiOn then
            Async_Ansi
          Else Write(CharIn);
          If UploadFlag and (Charin = #$13) then
            Delay(5000);
          If CharIn = #12 then
            ClrScr;
          If Ord(CharIn) > 31 THEN
            BEGIN
              Inc(count);
              PStringMain[count] := CharIn;
              PStringMain[0] := chr(count);
            END;
          If (CharIn = #10) or (PStringMain[0] > chr(79)) then
            BEGIN
              tokens := Parse_Str(SepStr,PStringMain,Pmain);
              count := 0;
              PStringMain[0] := chr(count);
            END;
          CharIn := #0;
        END
      ELSE BEGIN
        If UploadFlag then
          UploadChar(Modem);
        If KeyPressed then
          BEGIN
            CharIn := ReadKey;
            IF (CharIn = #0) THEN
              BEGIN
                ExtKeyProcs;
              END
            ELSE BEGIN
              If InputLine then
                InputChar(CharIn)
              else begin
                Async_Send(CharIn);
                If isEcho then
                  Write(Charin);
              end;
            END
          END
      END;
    END;
  ScreenExit;
  If CapFileOpen then
    SaveCapFile;
  Close(Modem);
  TerminateDialer;
  TerminateBuffer;
  TextColor(LightCyan);
  TextBackGround(Blue);
  SelectWindow(1);
  ClrScr;
  Write('     TradeWarsTerm v1.03 for ');
  TextColor(White);
  Write('THE ISOLATED PAWN: 1-919-471-1440');
  com_deinstall;
END.                          {city term}
